/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.openl.exception.OpenLCompilationException;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.openl.util.text.TextInterval;

public class Tokenizer {
    private static final int EOF = -1;
    private static String TOKEN_TYPE = "token";
    private static Map<String, Tokenizer> tokenizers = new ConcurrentHashMap<String, Tokenizer>();
    private boolean[] delimitersTable = new boolean[0];

    public Tokenizer(String delimiters) {
        this.makeTable(delimiters);
    }

    private void makeTable(String delimiters) {
        int i;
        if (StringUtils.isEmpty((CharSequence)delimiters)) {
            return;
        }
        char min = '\u0000';
        for (i = 0; i < delimiters.length(); ++i) {
            if (delimiters.charAt(i) <= min) continue;
            min = delimiters.charAt(i);
        }
        this.delimitersTable = new boolean[min + 1];
        for (i = 0; i < delimiters.length(); ++i) {
            this.delimitersTable[delimiters.charAt((int)i)] = true;
        }
    }

    private boolean isDelimiter(int character) {
        return character < this.delimitersTable.length && this.delimitersTable[character];
    }

    private IdentifierNode firstToken(IOpenSourceCodeModule source) throws OpenLCompilationException {
        try {
            int character;
            Reader reader = source.getCharacterStream();
            int startToken = 0;
            int position = -1;
            StringBuilder buffer = null;
            do {
                character = reader.read();
                ++position;
                if ((character == -1 || this.isDelimiter(character)) && buffer != null) {
                    String value = buffer.toString();
                    if (value.isEmpty()) {
                        buffer = null;
                        continue;
                    }
                    TextInterval location = LocationUtils.createTextInterval(startToken, position);
                    return new IdentifierNode(TOKEN_TYPE, location, value, source);
                }
                if (character == -1 || this.isDelimiter(character)) continue;
                if (buffer == null) {
                    buffer = new StringBuilder();
                    startToken = position;
                }
                buffer.append((char)character);
            } while (character != -1);
            return new IdentifierNode(TOKEN_TYPE, LocationUtils.createTextInterval(0, 0), "", source);
        }
        catch (IOException e) {
            throw new OpenLCompilationException("Parsing error", (Throwable)e, null, source);
        }
    }

    public IdentifierNode[] parse(IOpenSourceCodeModule source, ILocation textLocation) throws OpenLCompilationException {
        ArrayList<IdentifierNode> nodes = new ArrayList<IdentifierNode>();
        try {
            boolean continueLooping;
            Reader reader = source.getCharacterStream();
            int startToken = 0;
            int position = -1;
            if (textLocation != null) {
                startToken = textLocation.getStart().getAbsolutePosition(null);
                position = textLocation.getStart().getAbsolutePosition(null) - 1;
                for (int i = 0; i < startToken; ++i) {
                    reader.read();
                }
            }
            StringBuilder buffer = null;
            do {
                IdentifierNode node;
                TextInterval location;
                String value;
                int character = reader.read();
                ++position;
                if (character == -1 || this.isDelimiter(character)) {
                    if (buffer != null) {
                        value = buffer.toString().trim();
                        if (!value.isEmpty()) {
                            location = LocationUtils.createTextInterval(startToken, position);
                            node = new IdentifierNode(TOKEN_TYPE, location, value, source);
                            nodes.add(node);
                        }
                        buffer = null;
                    }
                } else if (!this.isDelimiter(character)) {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        startToken = position;
                    }
                    buffer.append((char)character);
                }
                if (textLocation != null) {
                    if (position < textLocation.getEnd().getAbsolutePosition(null)) {
                        continueLooping = character != -1;
                        continue;
                    }
                    if (buffer != null) {
                        value = buffer.toString().trim();
                        if (!value.isEmpty()) {
                            location = LocationUtils.createTextInterval(startToken, position);
                            node = new IdentifierNode(TOKEN_TYPE, location, value, source);
                            nodes.add(node);
                        }
                        buffer = null;
                    }
                    continueLooping = false;
                    continue;
                }
                boolean bl = continueLooping = character != -1;
            } while (continueLooping);
        }
        catch (IOException e) {
            throw new OpenLCompilationException("Parsing error", (Throwable)e, null, source);
        }
        return nodes.toArray(new IdentifierNode[nodes.size()]);
    }

    public static IdentifierNode firstToken(IOpenSourceCodeModule source, String delimiter) throws OpenLCompilationException {
        return Tokenizer.getTokenizer(delimiter).firstToken(source);
    }

    public static IdentifierNode[] tokenize(IOpenSourceCodeModule source, String delimiter) throws OpenLCompilationException {
        return Tokenizer.getTokenizer(delimiter).parse(source, null);
    }

    private static Tokenizer getTokenizer(String delimeter) {
        Tokenizer tokenizer = tokenizers.get(delimeter);
        if (tokenizer == null) {
            tokenizer = new Tokenizer(delimeter);
            tokenizers.put(delimeter, tokenizer);
        }
        return tokenizer;
    }

    public static IdentifierNode[] tokenize(IOpenSourceCodeModule source, String delimiter, ILocation location) throws OpenLCompilationException {
        return Tokenizer.getTokenizer(delimiter).parse(source, location);
    }
}

