/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.types.java.JavaNoAggregateInfo;
import org.openl.util.AOpenIterator;
import org.openl.vm.IRuntimeEnv;

public abstract class ADynamicClass
extends AOpenClass {
    private static final int MAX_DIM = 5;
    private String name = "<anonymous class>";
    protected Map<String, IOpenField> fieldMap;
    private Class<?> instanceClass;
    private IOpenClass[] arrayTypes = new IOpenClass[5];

    public ADynamicClass(String name, Class<?> instanceClass) {
        this.name = name;
        this.instanceClass = instanceClass;
        this.fieldMap = this.fieldMap();
        this.addMethod(new OpenConstructor(this));
    }

    public void addField(IOpenField field) {
        Map<String, IOpenField> fields = this.fieldMap();
        if (fields.containsKey(field.getName())) {
            IOpenField existedField = fields.get(field.getName());
            if (existedField != field) {
                throw new DuplicatedVarException("", field.getName());
            }
            return;
        }
        this.fieldMap().put(field.getName(), field);
        this.addFieldToLowerCaseMap(field);
    }

    @Override
    public void addMethod(IOpenMethod method) {
        super.addMethod(method);
    }

    @Override
    protected Map<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, IOpenField>();
        }
        return this.fieldMap;
    }

    @Override
    public IAggregateInfo getAggregateInfo() {
        return JavaNoAggregateInfo.NO_AGGREGATE;
    }

    public String getDisplayName(int mode) {
        return this.name;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(Class<?> instanceClass) {
        this.instanceClass = instanceClass;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.instanceClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return false;
    }

    @Override
    public boolean isInstance(Object instance) {
        return false;
    }

    @Override
    public Iterator<IOpenClass> superClasses() {
        return AOpenIterator.empty();
    }

    protected IOpenClass[] getArrayTypes() {
        return this.arrayTypes;
    }

    public static class OpenConstructor
    implements IOpenMethod {
        IOpenClass openClass;

        OpenConstructor(IOpenClass openClass) {
            this.openClass = openClass;
        }

        @Override
        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public String getDisplayName(int mode) {
            return this.openClass.getDisplayName(mode);
        }

        @Override
        public IMemberMetaInfo getInfo() {
            return null;
        }

        @Override
        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return this.openClass.getName();
        }

        @Override
        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        @Override
        public IOpenClass getType() {
            return this.openClass;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            return this.openClass.newInstance(env);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return this.openClass.getName();
        }
    }
}

