/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.Array;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;
import org.openl.util.IntegerValuesUtils;

public class ArrayFieldIndex
implements IOpenIndex {
    private IOpenClass elementType;
    private IOpenField indexField;

    public ArrayFieldIndex(IOpenClass elementType, IOpenField indexField) {
        this.elementType = elementType;
        this.indexField = indexField;
    }

    @Override
    public IOpenClass getElementType() {
        return this.elementType;
    }

    @Override
    public IOpenClass getIndexType() {
        return this.indexField.getType();
    }

    @Override
    public Object getValue(Object container, Object index) {
        if (index != null) {
            int len = Array.getLength(container);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(container, i);
                Object fieldValue = this.indexField.get(obj, null);
                if (index instanceof String && IntegerValuesUtils.isIntegerValue(fieldValue.getClass())) {
                    index = IntegerValuesUtils.createNewObjectByType(fieldValue.getClass(), (String)index);
                }
                if (!index.equals(fieldValue)) continue;
                return obj;
            }
        }
        return null;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public void setValue(Object container, Object index, Object value) {
        throw new UnsupportedOperationException();
    }
}

