/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.openl.IOpenRunner;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.BlockNode;
import org.openl.binding.impl.ControlSignalReturn;
import org.openl.types.Invokable;
import org.openl.types.impl.CompositeMethod;
import org.openl.vm.IRuntimeEnv;

public class CompositeMethodInvoker
implements Invokable {
    private IBoundMethodNode methodBodyBoundNode;
    private IBoundNode expressionNode;

    public CompositeMethodInvoker(IBoundMethodNode methodBodyBoundNode, CompositeMethod method) {
        this.methodBodyBoundNode = methodBodyBoundNode;
        this.optimizeMethodCall(methodBodyBoundNode, method);
    }

    private void optimizeMethodCall(IBoundMethodNode methodBodyBoundNode, CompositeMethod method) {
        BlockNode mbb;
        if (methodBodyBoundNode instanceof BlockNode && (mbb = (BlockNode)methodBodyBoundNode).getChildren().length == 1 && mbb.getLocalFrameSize() == method.getSignature().getNumberOfParameters()) {
            this.expressionNode = mbb.getChildren()[0];
        }
        if (this.expressionNode != null) {
            this.methodBodyBoundNode = null;
        }
    }

    public void removeDebugInformation() {
        if (this.expressionNode != null) {
            this.clearSyntaxNodes(this.expressionNode);
        }
        if (this.methodBodyBoundNode != null) {
            this.clearSyntaxNodes(this.methodBodyBoundNode);
        }
    }

    private void clearSyntaxNodes(IBoundNode boundNode) {
        IBoundNode[] children;
        if (boundNode instanceof ABoundNode) {
            ((ABoundNode)boundNode).setSyntaxNode(null);
        }
        if ((children = boundNode.getChildren()) != null) {
            for (IBoundNode child : children) {
                this.clearSyntaxNodes(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        try {
            env.pushThis(target);
            IOpenRunner runner = env.getRunner();
            Object object = this.expressionNode == null ? runner.run(this.methodBodyBoundNode, params, env) : runner.runExpression(this.expressionNode, params, env);
            return object;
        }
        catch (ControlSignalReturn csret) {
            Object object = csret.getReturnValue();
            return object;
        }
        finally {
            env.popThis();
        }
    }
}

