/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.Array;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.AOpenField;
import org.openl.types.impl.DatatypeOpenField;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeArrayElementField
extends AOpenField {
    private final Logger log = LoggerFactory.getLogger(DatatypeOpenField.class);
    private int elementIndex;
    private IOpenField field;

    public DatatypeArrayElementField(IOpenField field, int elementIndex, IOpenClass type) {
        super(DatatypeArrayElementField.getName(field.getName(), elementIndex), type);
        this.elementIndex = elementIndex;
        this.field = field;
    }

    public DatatypeArrayElementField(IOpenField field, int elementIndex) {
        super(DatatypeArrayElementField.getName(field.getName(), elementIndex), field.getType().getComponentClass());
        this.elementIndex = elementIndex;
        this.field = field;
    }

    @Override
    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return null;
        }
        Object res = null;
        try {
            Object arr = this.field.get(target, env);
            res = arr == null || Array.getLength(arr) < this.elementIndex + 1 ? this.getType().nullObject() : Array.get(arr, this.elementIndex);
        }
        catch (SecurityException e) {
            this.processError(e);
        }
        return res != null ? res : this.getType().nullObject();
    }

    @Override
    public void set(Object target, Object value, IRuntimeEnv env) {
        if (target == null) {
            throw new OpenLRuntimeException(String.format("Can not set [%s] field to \"null\" object", this.getName()));
        }
        try {
            Object arr = this.field.get(target, env);
            if (arr == null) {
                Object array = Array.newInstance(this.getType().getInstanceClass(), this.elementIndex + 1);
                Array.set(array, this.elementIndex, value);
                this.setArrayIntoTarget(target, array, env);
            } else if (Array.getLength(arr) < this.elementIndex + 1) {
                Object newArray = Array.newInstance(this.getType().getInstanceClass(), this.elementIndex + 1);
                int oldArryLeng = Array.getLength(arr);
                for (int i = 0; i < oldArryLeng; ++i) {
                    Array.set(newArray, i, Array.get(arr, i));
                }
                Array.set(newArray, this.elementIndex, value);
                this.setArrayIntoTarget(target, newArray, env);
            } else {
                Array.set(arr, this.elementIndex, value);
            }
        }
        catch (SecurityException e) {
            this.processError(e);
        }
    }

    private void processError(Throwable e1) {
        this.log.error("{}", (Object)this, (Object)e1);
        OpenLMessagesUtils.addError(e1);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    private static String getName(String name, int index) {
        return name + "[" + index + "]";
    }

    private void setArrayIntoTarget(Object target, Object array, IRuntimeEnv env) {
        this.field.set(target, array, env);
    }
}

