/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.binding.exception.AmbiguousTypeException;
import org.openl.types.IOpenClass;
import org.openl.types.ITypeLibrary;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.ISelector;

public class ImportTypeLibrary
implements ITypeLibrary {
    protected ITypeLibrary library;
    String[] imports;
    String[] classes;
    Map<String, String> aliases;

    public ImportTypeLibrary(ITypeLibrary library, String[] imports, String[] classes) {
        this.library = library;
        this.imports = imports;
        this.aliases = new HashMap<String, String>();
        for (int i = 0; i < classes.length; ++i) {
            int index = classes[i].lastIndexOf(46);
            if (index <= 0) continue;
            this.aliases.put(classes[i].substring(index + 1), classes[i]);
        }
    }

    @Override
    public IOpenClass getType(String typename) throws AmbiguousTypeException {
        IOpenClass type = null;
        String alias = this.aliases.get(typename);
        if (alias != null) {
            type = this.library.getType(alias);
        }
        if (type != null) {
            return type;
        }
        for (int i = 0; i < this.imports.length; ++i) {
            alias = this.imports[i] + '.' + typename;
            type = this.library.getType(alias);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    protected boolean isLongName(String typename) {
        return typename.indexOf(46) >= 0;
    }

    @Override
    public Iterator<String> typeNames() {
        return AOpenIterator.select(this.library.typeNames(), (ISelector)new ImportSelector());
    }

    class ImportSelector
    extends ASelector<String> {
        ImportSelector() {
        }

        public boolean select(String name) {
            int dotIndex = name.lastIndexOf(46);
            for (int i = 0; i < ImportTypeLibrary.this.imports.length; ++i) {
                if (!name.startsWith(ImportTypeLibrary.this.imports[i]) || dotIndex != ImportTypeLibrary.this.imports[i].length()) continue;
                return true;
            }
            return false;
        }
    }
}

