/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public final class MethodKey {
    private String name;
    private IOpenClass[] internalParameters;
    int hashCode = 0;

    public MethodKey(IOpenMethod om) {
        this.name = om.getName();
        IOpenClass[] pars = om.getSignature().getParameterTypes();
        this.internalParameters = this.getNormalizedParams(pars);
    }

    public MethodKey(String name, IOpenClass[] pars) {
        this.name = name;
        this.internalParameters = this.getNormalizedParams(pars);
    }

    public MethodKey(String name, IOpenClass[] parTypes, boolean doNotNormalizeParams) {
        this.name = name;
        this.internalParameters = doNotNormalizeParams ? parTypes : this.getNormalizedParams(parTypes);
    }

    private IOpenClass[] getNormalizedParams(IOpenClass[] originalParams) {
        if (originalParams == null) {
            return null;
        }
        int firstParamToConvert = -1;
        for (int i = 0; i < originalParams.length; ++i) {
            if (originalParams[i] instanceof JavaOpenClass) continue;
            firstParamToConvert = i;
            break;
        }
        if (firstParamToConvert == -1) {
            return originalParams;
        }
        IOpenClass[] normalizedParams = new IOpenClass[originalParams.length];
        if (firstParamToConvert > 0) {
            System.arraycopy(originalParams, 0, normalizedParams, 0, firstParamToConvert);
        }
        for (int i = firstParamToConvert; i < originalParams.length; ++i) {
            IOpenClass param;
            IOpenClass normParam = param = originalParams[i];
            if (param instanceof DomainOpenClass || param instanceof AOpenClass && param.getInstanceClass() != null) {
                normParam = JavaOpenClass.getOpenClass(param.getInstanceClass());
            }
            normalizedParams[i] = normParam;
        }
        return normalizedParams;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey mk = (MethodKey)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)mk.name).append((Object[])this.internalParameters, (Object[])mk.internalParameters).isEquals();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = new HashCodeBuilder().append((Object)this.name).append((Object[])this.internalParameters).toHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        boolean first = true;
        for (IOpenClass c : this.internalParameters) {
            if (!first) {
                sb.append(",");
            }
            sb.append(c.getName());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }
}

