/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.MethodNotFoundException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public class MethodsHelper {
    private MethodsHelper() {
    }

    public static IOpenMethod[] getMethods(String name, Collection<IOpenMethod> methods) {
        ArrayList<IOpenMethod> list = new ArrayList<IOpenMethod>();
        for (IOpenMethod m : methods) {
            if (!name.equals(m.getName())) continue;
            list.add(m);
        }
        if (list.isEmpty()) {
            throw new MethodNotFoundException(null, name, IOpenClass.EMPTY);
        }
        return list.toArray(new IOpenMethod[0]);
    }

    public static IOpenMethod getSingleMethod(String name, Collection<IOpenMethod> methods) {
        ArrayList<IOpenMethod> list = new ArrayList<IOpenMethod>();
        for (IOpenMethod m : methods) {
            if (!m.getName().equals(name)) continue;
            list.add(m);
        }
        if (list.isEmpty()) {
            throw new MethodNotFoundException(null, name, IOpenClass.EMPTY);
        }
        if (list.size() > 1) {
            throw new AmbiguousMethodException(name, IOpenClass.EMPTY, list);
        }
        return (IOpenMethod)list.get(0);
    }
}

