/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openl.binding.exception.AmbiguousTypeException;
import org.openl.conf.ClassFactory;
import org.openl.types.IOpenClass;
import org.openl.types.ITypeLibrary;
import org.openl.types.java.JavaOpenClass;

public class JavaImportTypeLibrary
implements ITypeLibrary {
    private HashMap<String, IOpenClass> aliases = new HashMap();
    private Set<String> notFound = new HashSet<String>();
    private List<String> importPackages = new ArrayList<String>();
    private ClassLoader loader;

    public JavaImportTypeLibrary(List<String> importClasses, List<String> importPackages, ClassLoader loader) {
        this.loader = loader;
        this.importPackages = importPackages;
        if (importClasses != null) {
            for (String importClass : importClasses) {
                int index = importClass.lastIndexOf(46);
                String alias = importClass.substring(index + 1);
                Class<?> c = ClassFactory.forName(importClass, loader);
                this.aliases.put(alias, JavaOpenClass.getOpenClass(c));
            }
        }
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public synchronized IOpenClass getType(String typename) throws AmbiguousTypeException {
        IOpenClass oc = this.aliases.get(typename);
        if (oc != null) {
            return oc;
        }
        if (this.notFound.contains(typename)) {
            return null;
        }
        for (String singleImport : this.importPackages) {
            try {
                Class<?> c = ClassFactory.forName(singleImport + "." + typename, this.getClassLoader());
                oc = JavaOpenClass.getOpenClass(c);
                this.aliases.put(typename, oc);
                return oc;
            }
            catch (Throwable throwable) {
            }
        }
        this.notFound.add(typename);
        return null;
    }

    @Override
    public Iterator<String> typeNames() {
        return null;
    }
}

