/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.impl.AAggregateInfo;
import org.openl.types.java.JavaOpenClass;

public class JavaListAggregateInfo
extends AAggregateInfo {
    public static final IAggregateInfo LIST_AGGREGATE = new JavaListAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        return JavaOpenClass.OBJECT;
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        if (indexType != JavaOpenClass.INT && indexType.getInstanceClass() != Integer.class) {
            return null;
        }
        if (!this.isAggregate(aggregateType)) {
            return null;
        }
        return this.makeListIndex(aggregateType);
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return ((Collection)aggregate).iterator();
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return true;
    }

    private IOpenIndex makeListIndex(IOpenClass aggregateType) {
        return new ListIndex(this.getComponentType(aggregateType));
    }

    static class ListIndex
    implements IOpenIndex {
        IOpenClass elementType;

        public ListIndex(IOpenClass elementType) {
            this.elementType = elementType;
        }

        @Override
        public IOpenClass getElementType() {
            return this.elementType;
        }

        @Override
        public IOpenClass getIndexType() {
            return JavaOpenClass.INT;
        }

        @Override
        public Object getValue(Object container, Object index) {
            return ((List)container).get((Integer)index);
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void setValue(Object container, Object index, Object value) {
            ((List)container).set((Integer)index, value);
        }
    }
}

