/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.StringValue;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.ArrayIndex;
import org.openl.types.impl.ArrayLengthOpenField;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.BeanOpenField;
import org.openl.types.java.CustomJavaOpenClass;
import org.openl.types.java.JavaArrayAggregateInfo;
import org.openl.types.java.JavaListAggregateInfo;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.JavaOpenEnum;
import org.openl.types.java.JavaOpenField;
import org.openl.types.java.JavaOpenMethod;
import org.openl.types.java.OpenClassHelper;
import org.openl.util.AOpenIterator;
import org.openl.util.CollectionsUtil;
import org.openl.util.IConvertor;
import org.openl.util.IOpenIterator;
import org.openl.util.OpenIterator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;
import org.openl.vm.IRuntimeEnv;

public class JavaOpenClass
extends AOpenClass {
    public static final IConvertor<Class, IOpenClass> Class2JavaOpenClass = new Class2JavaOpenClassCollector();
    private static Map<Class<?>, JavaOpenClass> javaClassCache;
    private static Map<Class<?>, JavaOpenClass> classCache;
    public static final JavaOpenClass INT;
    public static final JavaOpenClass LONG;
    public static final JavaOpenClass DOUBLE;
    public static final JavaOpenClass FLOAT;
    public static final JavaOpenClass SHORT;
    public static final JavaOpenClass CHAR;
    public static final JavaOpenClass BYTE;
    public static final JavaOpenClass BOOLEAN;
    public static final JavaOpenClass VOID;
    public static final JavaOpenClass STRING;
    public static final JavaOpenClass OBJECT;
    public static final JavaOpenClass CLASS;
    protected Class<?> instanceClass;
    private final boolean simple;
    private IAggregateInfo aggregateInfo;
    protected HashMap<String, IOpenField> fields;
    private static final Lock cacheLock;
    String name;
    IOpenClass[] superClasses;

    private static Map<Class<?>, JavaOpenClass> getClassCache() {
        if (javaClassCache == null) {
            cacheLock.lock();
            try {
                if (javaClassCache == null) {
                    javaClassCache = new HashMap();
                    javaClassCache.put(Integer.TYPE, INT);
                    javaClassCache.put(Integer.class, new JavaOpenClass(Integer.class, true));
                    javaClassCache.put(Long.TYPE, LONG);
                    javaClassCache.put(Long.class, new JavaOpenClass(Long.class, true));
                    javaClassCache.put(Double.TYPE, DOUBLE);
                    javaClassCache.put(Double.class, new JavaOpenClass(Double.class, true));
                    javaClassCache.put(Float.TYPE, FLOAT);
                    javaClassCache.put(Float.class, new JavaOpenClass(Float.class, true));
                    javaClassCache.put(Short.TYPE, SHORT);
                    javaClassCache.put(Short.class, new JavaOpenClass(Short.class, true));
                    javaClassCache.put(Character.TYPE, CHAR);
                    javaClassCache.put(Character.class, new JavaOpenClass(Character.class, true));
                    javaClassCache.put(Byte.TYPE, BYTE);
                    javaClassCache.put(Byte.class, new JavaOpenClass(Byte.class, true));
                    javaClassCache.put(Boolean.TYPE, BOOLEAN);
                    javaClassCache.put(Boolean.class, new JavaOpenClass(Boolean.class, true));
                    javaClassCache.put(Void.TYPE, VOID);
                    javaClassCache.put(String.class, STRING);
                    javaClassCache.put(Object.class, OBJECT);
                    javaClassCache.put(Class.class, CLASS);
                    javaClassCache.put(Date.class, new JavaOpenClass(Date.class, true));
                    javaClassCache.put(BigInteger.class, new JavaOpenClass(BigInteger.class, true));
                    javaClassCache.put(BigDecimal.class, new JavaOpenClass(BigDecimal.class, true));
                    javaClassCache.put(BigDecimalValue.class, new JavaOpenClass(BigDecimalValue.class, true));
                    javaClassCache.put(BigIntegerValue.class, new JavaOpenClass(BigIntegerValue.class, true));
                    javaClassCache.put(ByteValue.class, new JavaOpenClass(ByteValue.class, true));
                    javaClassCache.put(DoubleValue.class, new JavaOpenClass(DoubleValue.class, true));
                    javaClassCache.put(FloatValue.class, new JavaOpenClass(FloatValue.class, true));
                    javaClassCache.put(IntValue.class, new JavaOpenClass(IntValue.class, true));
                    javaClassCache.put(LongValue.class, new JavaOpenClass(LongValue.class, true));
                    javaClassCache.put(ShortValue.class, new JavaOpenClass(ShortValue.class, true));
                    javaClassCache.put(StringValue.class, new JavaOpenClass(StringValue.class, true));
                    classCache.putAll(javaClassCache);
                }
            }
            finally {
                cacheLock.unlock();
            }
        }
        return classCache;
    }

    protected JavaOpenClass(Class<?> instanceClass) {
        this(instanceClass, false);
    }

    protected JavaOpenClass(Class<?> instanceClass, boolean simple) {
        this.instanceClass = instanceClass;
        this.simple = simple;
    }

    public static synchronized JavaOpenClass getOpenClass(Class<?> c) {
        JavaOpenClass res = JavaOpenClass.getClassCache().get(c);
        if (res == null) {
            CustomJavaOpenClass annotation;
            res = c.isInterface() ? new JavaOpenInterface(c) : (c.isEnum() ? new JavaOpenEnum(c) : ((annotation = c.getAnnotation(CustomJavaOpenClass.class)) != null ? JavaOpenClass.createOpenClass(c, annotation) : new JavaOpenClass(c)));
            JavaOpenClass.getClassCache().put(c, res);
        }
        return res;
    }

    private static JavaOpenClass createOpenClass(Class<?> c, CustomJavaOpenClass annotation) {
        Class<? extends JavaOpenClass> type = annotation.type();
        try {
            return type.getConstructor(Class.class).newInstance(c);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Cannot find constructor with signature 'public MyCustomJavaOpenClass(Class<?> c)' in type %s", type.getCanonicalName()), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(String.format("Error while creating a custom JavaOpenClass of type '%s'", type.getCanonicalName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Constructor of a custom JavaOpenClass of type '%s' is inaccessible", type.getCanonicalName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Constructor of a class '%s' threw and exception", type.getCanonicalName()), e);
        }
    }

    public static IOpenClass[] getOpenClasses(Class<?>[] cc) {
        if (cc.length == 0) {
            return IOpenClass.EMPTY;
        }
        Object[] ary = new IOpenClass[cc.length];
        CollectionsUtil.collect((Object[])ary, (Object[])cc, Class2JavaOpenClass);
        return ary;
    }

    public static Class<?> makeArrayClass(Class<?> c) {
        return Array.newInstance(c, 0).getClass();
    }

    public static ArrayIndex makeArrayIndex(IOpenClass arrayType) {
        return new ArrayIndex(JavaOpenClass.getOpenClass(arrayType.getInstanceClass().getComponentType()));
    }

    public static synchronized void printCache() {
        int i = 0;
        for (Class<?> element : JavaOpenClass.getClassCache().keySet()) {
            System.out.println("" + i++ + ":\t" + JavaOpenClass.printClass(element));
        }
    }

    protected static String printClass(Class<?> c) {
        if (c.isArray()) {
            return "[]" + JavaOpenClass.printClass(c.getComponentType());
        }
        return c.getName();
    }

    public static synchronized void resetAllClassloaders(HashMap<?, ClassLoader> oldLoaders) {
        for (ClassLoader cl : oldLoaders.values()) {
            JavaOpenClass.resetClassloader(cl);
        }
    }

    public static synchronized void resetClassloader(ClassLoader cl) {
        ArrayList toRemove = new ArrayList();
        for (Class<Object> c : JavaOpenClass.getClassCache().keySet()) {
            ClassLoader classLoader = c.getClassLoader();
            if (javaClassCache.containsKey(c)) continue;
            if (classLoader == cl) {
                toRemove.add(c);
            }
            if (!(cl instanceof OpenLBundleClassLoader) || !((OpenLBundleClassLoader)cl).containsClassLoader(classLoader)) continue;
            toRemove.add(c);
        }
        for (Class<Object> c : toRemove) {
            JavaOpenClass.getClassCache().remove(c);
        }
    }

    public static boolean isVoid(IOpenClass clazz) {
        return VOID.equals(clazz);
    }

    protected void collectBeanFields() {
        BeanOpenField.collectFields(this.fields, this.instanceClass, null, null);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavaOpenClass)) {
            return false;
        }
        return this.instanceClass == ((JavaOpenClass)obj).instanceClass;
    }

    public boolean equalsAsPrimitive(Object obj) {
        if (!(obj instanceof JavaPrimitiveClass)) {
            return false;
        }
        return ((JavaPrimitiveClass)obj).equalsAsPrimitive(this);
    }

    @Override
    protected synchronized Map<String, IOpenField> fieldMap() {
        if (this.fields == null) {
            this.fields = new HashMap();
            Field[] ff = this.instanceClass.getDeclaredFields();
            if (this.isPublic(this.instanceClass)) {
                for (int i = 0; i < ff.length; ++i) {
                    if (!this.isPublic(ff[i])) continue;
                    this.fields.put(ff[i].getName(), new JavaOpenField(ff[i]));
                }
            }
            if (this.instanceClass.isArray()) {
                this.fields.put("length", new JavaArrayLengthField());
            }
            this.fields.put("class", new JavaClassClassField(this.instanceClass));
            this.collectBeanFields();
        }
        return this.fields;
    }

    @Override
    public synchronized IAggregateInfo getAggregateInfo() {
        if (this.aggregateInfo != null) {
            return this.aggregateInfo;
        }
        this.aggregateInfo = List.class.isAssignableFrom(this.getInstanceClass()) ? JavaListAggregateInfo.LIST_AGGREGATE : JavaArrayAggregateInfo.ARRAY_AGGREGATE;
        return this.aggregateInfo;
    }

    public String getDisplayName(int mode) {
        String name = this.getName();
        switch (mode) {
            default: {
                return StringTool.lastToken((String)name, (String)".");
            }
            case 2: 
        }
        return name;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    @Override
    public IOpenMethod getMatchingMethod(String name, IOpenClass[] params) throws AmbiguousMethodException {
        return this.getMethod(name, params);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.instanceClass.getCanonicalName();
        }
        return this.name;
    }

    public String getSimpleName() {
        return this.getDisplayName(0);
    }

    @Override
    public int hashCode() {
        return this.instanceClass.hashCode();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.instanceClass.getModifiers());
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.instanceClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return this.instanceClass.isAssignableFrom(ioc.getInstanceClass());
    }

    @Override
    public boolean isInstance(Object instance) {
        return this.instanceClass.isInstance(instance);
    }

    protected boolean isPublic(Class<?> declaringClass) {
        return Modifier.isPublic(declaringClass.getModifiers());
    }

    protected boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        HashMap<MethodKey, IOpenMethod> methods = new HashMap<MethodKey, IOpenMethod>();
        Method[] mm = this.instanceClass.getDeclaredMethods();
        if (this.isPublic(this.instanceClass)) {
            for (int i = 0; i < mm.length; ++i) {
                if (!this.isPublic(mm[i])) continue;
                JavaOpenMethod om = new JavaOpenMethod(mm[i]);
                methods.put(new MethodKey(om), om);
            }
        }
        Constructor<?>[] cc = this.instanceClass.getDeclaredConstructors();
        for (int i = 0; i < cc.length; ++i) {
            if (!this.isPublic(cc[i])) continue;
            JavaOpenConstructor om = new JavaOpenConstructor(cc[i]);
            methods.put(new MethodKey(om), om);
        }
        if (methods.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(methods);
    }

    @Override
    public Object newInstance(IRuntimeEnv env) {
        try {
            return this.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    @Override
    public Object nullObject() {
        return null;
    }

    @Override
    public IOpenClass getComponentClass() {
        if (this.isArray() || OpenClassHelper.isCollection(this)) {
            return this.getAggregateInfo().getComponentType(this);
        }
        return null;
    }

    @Override
    public synchronized Iterator<IOpenClass> superClasses() {
        if (this.superClasses == null) {
            IOpenIterator<IOpenClass> sc = this.collectSuperClasses();
            this.superClasses = sc.asList().toArray(new IOpenClass[0]);
        }
        return OpenIterator.fromArray((Object[])this.superClasses);
    }

    private IOpenIterator<IOpenClass> collectSuperClasses() {
        Object[] tmp = this.instanceClass.getInterfaces();
        IOpenIterator ic = OpenIterator.fromArray((Object[])tmp);
        IOpenIterator interfaces = ic.collect(new Class2JavaOpenClassCollector());
        Class<?> superClass = this.instanceClass.getSuperclass();
        if (superClass == null) {
            return interfaces;
        }
        return AOpenIterator.merge((IOpenIterator)AOpenIterator.single((Object)JavaOpenClass.getOpenClass(superClass)), (IOpenIterator)interfaces);
    }

    static {
        classCache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.SOFT, AbstractReferenceMap.ReferenceStrength.SOFT);
        INT = new JavaPrimitiveClass(Integer.TYPE, Integer.class, 0);
        LONG = new JavaPrimitiveClass(Long.TYPE, Long.class, 0L);
        DOUBLE = new JavaPrimitiveClass(Double.TYPE, Double.class, 0.0);
        FLOAT = new JavaPrimitiveClass(Float.TYPE, Float.class, Float.valueOf(0.0f));
        SHORT = new JavaPrimitiveClass(Short.TYPE, Short.class, (short)0);
        CHAR = new JavaPrimitiveClass(Character.TYPE, Character.class, Character.valueOf('\u0000'));
        BYTE = new JavaPrimitiveClass(Byte.TYPE, Byte.class, (byte)0);
        BOOLEAN = new JavaPrimitiveClass(Boolean.TYPE, Boolean.class, Boolean.FALSE);
        VOID = new JavaPrimitiveClass(Void.TYPE, Void.class, null);
        STRING = new JavaOpenClass(String.class, true);
        OBJECT = new JavaOpenClass(Object.class, false);
        CLASS = new JavaOpenClass(Class.class, true);
        cacheLock = new ReentrantLock();
    }

    private static class JavaOpenInterface
    extends JavaOpenClass {
        private static Method toString;
        private static Method equals;
        private static Method hashCode;
        private Map<Method, BeanOpenField> getters;
        private Map<Method, BeanOpenField> setters;
        private Class<?> proxyClass;
        private InvocationHandler beanInterfaceHandler;

        protected JavaOpenInterface(Class<?> instanceClass) {
            super(instanceClass);
            this.proxyClass = Proxy.getProxyClass(instanceClass.getClassLoader(), instanceClass);
        }

        @Override
        protected void collectBeanFields() {
            this.getters = new HashMap<Method, BeanOpenField>();
            this.setters = new HashMap<Method, BeanOpenField>();
            BeanOpenField.collectFields(this.fields, this.instanceClass, this.getters, this.setters);
        }

        private synchronized InvocationHandler getInvocationHandler(Class<?> instClass) {
            if (List.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new ArrayList());
            }
            if (Set.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new HashSet());
            }
            if (SortedMap.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new TreeMap());
            }
            if (Map.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new HashMap());
            }
            if (Collection.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new ArrayList());
            }
            if (this.beanInterfaceHandler == null) {
                this.beanInterfaceHandler = new BeanInterfaceInvocationHandler();
            }
            return this.beanInterfaceHandler;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            try {
                return Proxy.newProxyInstance(this.instanceClass.getClassLoader(), new Class[]{this.instanceClass}, this.getInvocationHandler(this.instanceClass));
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }

        static {
            try {
                toString = Object.class.getMethod("toString", new Class[0]);
                equals = Object.class.getMethod("equals", Object.class);
                hashCode = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw RuntimeExceptionWrapper.wrap((Throwable)nsme);
            }
        }

        private class BeanInterfaceInvocationHandler
        implements InvocationHandler {
            private IdentityHashMap<Object, HashMap<BeanOpenField, Object>> map = new IdentityHashMap();

            private BeanInterfaceInvocationHandler() {
            }

            @Override
            public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                HashMap<BeanOpenField, Object> values = this.map.get(proxy);
                if (values == null) {
                    values = new HashMap();
                    this.map.put(proxy, values);
                }
                BeanOpenField bf = null;
                if (JavaOpenInterface.this.getters != null) {
                    bf = (BeanOpenField)JavaOpenInterface.this.getters.get(method);
                }
                if (bf != null) {
                    Object res = values.get(bf);
                    return res != null ? res : bf.getType().nullObject();
                }
                if (JavaOpenInterface.this.setters != null) {
                    bf = (BeanOpenField)JavaOpenInterface.this.setters.get(method);
                }
                if (bf != null) {
                    values.put(bf, args[0]);
                    return null;
                }
                if (method.getName().equals(toString.getName())) {
                    return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                if (method.getName().equals(hashCode.getName())) {
                    return System.identityHashCode(proxy);
                }
                if (method.getName().equals(equals.getName())) {
                    return proxy == args[0];
                }
                throw new RuntimeException("Default Interface Proxy Implementation does not support method " + method.getDeclaringClass().getName() + "::" + method.getName() + ". Only bean access is supported");
            }
        }

        private class JavaInstanceBasedInvocationhandler
        implements InvocationHandler {
            Object instance;

            public JavaInstanceBasedInvocationhandler(Object instance) {
                this.instance = instance;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(this.instance, args);
            }
        }
    }

    private static class JavaPrimitiveClass
    extends JavaOpenClass {
        private Class<?> wrapperClass;
        private Object nullObject;

        public JavaPrimitiveClass(Class<?> instanceClass, Class<?> wrapperClass, Object nullObject) {
            super(instanceClass, true);
            this.wrapperClass = wrapperClass;
            this.nullObject = nullObject;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            return this.nullObject;
        }

        @Override
        public Object nullObject() {
            return this.nullObject;
        }

        @Override
        public boolean equalsAsPrimitive(Object obj) {
            if (!(obj instanceof JavaOpenClass)) {
                return false;
            }
            return this.wrapperClass == ((JavaOpenClass)obj).instanceClass;
        }
    }

    private static class JavaClassClassField
    implements IOpenField {
        private Class<?> instanceClass;

        public JavaClassClassField(Class<?> instanceClass) {
            this.instanceClass = instanceClass;
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            return this.instanceClass;
        }

        @Override
        public IOpenClass getDeclaringClass() {
            return null;
        }

        public String getDisplayName(int mode) {
            return "class";
        }

        @Override
        public IMemberMetaInfo getInfo() {
            return null;
        }

        public String getName() {
            return "class";
        }

        @Override
        public IOpenClass getType() {
            return CLASS;
        }

        @Override
        public boolean isConst() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public void set(Object target, Object value, IRuntimeEnv env) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class JavaArrayLengthField
    extends ArrayLengthOpenField {
        private JavaArrayLengthField() {
        }

        @Override
        public int getLength(Object target) {
            return Array.getLength(target);
        }
    }

    private static class Class2JavaOpenClassCollector<T>
    implements IConvertor<Class<T>, IOpenClass> {
        private Class2JavaOpenClassCollector() {
        }

        public IOpenClass convert(Class<T> c) {
            return JavaOpenClass.getOpenClass(c);
        }
    }
}

