/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.AOpenFactory;
import org.openl.types.java.JavaOpenSchema;

public class JavaOpenFactory
extends AOpenFactory {
    @Override
    public IOpenSchema loadSchema(String uri) throws Exception {
        return this.loadSchemaUsingClasspath(this.splitClassPath(uri));
    }

    IOpenSchema loadSchemaUsingClasspath(String[] classpath) throws Exception {
        URL[] urls = new URL[classpath.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new File(classpath[i]).getCanonicalFile().toURI().toURL();
        }
        return new JavaOpenSchema(this, classpath, new URLClassLoader(urls));
    }

    protected String[] splitClassPath(String classpath) {
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        String[] res = new String[st.countTokens()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = st.nextToken();
        }
        return res;
    }
}

