/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenClassHolder;
import org.openl.types.IOpenFactory;
import org.openl.types.impl.AOpenSchema;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ASelector;
import org.openl.util.IConvertor;
import org.openl.util.IOpenIterator;
import org.openl.util.ISelector;
import org.openl.util.OpenIterator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.tree.FileTreeIterator;

public class JavaOpenSchema
extends AOpenSchema {
    static final ISelector<String> CLASSFILENAME_SELECTOR = new ClassNameSelector();
    String[] classpath;
    ClassLoader classLoader;

    public JavaOpenSchema(IOpenFactory factory, String[] classpath, ClassLoader classLoader) {
        super(factory);
        this.classpath = classpath;
        this.classLoader = classLoader;
    }

    @Override
    protected Map<String, IOpenClassHolder> buildAllClasses() {
        HashMap<String, IOpenClassHolder> map = new HashMap<String, IOpenClassHolder>();
        for (int i = 0; i < this.classpath.length; ++i) {
            try {
                Iterator<String> iter = this.getIterator(this.classpath[i]);
                while (iter.hasNext()) {
                    String className = iter.next();
                    map.put(className, new JavaOpenClassHolder(className, this.classLoader));
                }
                continue;
            }
            catch (Exception ex) {
                RuntimeExceptionWrapper.wrap((Throwable)ex);
            }
        }
        return map;
    }

    public String[] getClasspath() {
        return this.classpath;
    }

    protected Iterator<String> getDirectoryIterator(String dirname) throws Exception {
        IConvertor<File, String> fileToStringCollector = new IConvertor<File, String>(){

            public String convert(File f) {
                return f.getAbsolutePath();
            }
        };
        File dir = new File(dirname).getCanonicalFile();
        String dirName = dir.getAbsolutePath();
        return new FileTreeIterator(dir, 0).collect((IConvertor)fileToStringCollector).select(CLASSFILENAME_SELECTOR).collect((IConvertor)new FileNameToClassCollector(dirName.length() + 1, File.separatorChar));
    }

    protected Iterator<String> getIterator(String classPathComponent) throws Exception {
        if (classPathComponent.endsWith(".jar") || classPathComponent.endsWith(".zip")) {
            return this.getJarOrZipIterator(classPathComponent);
        }
        if (classPathComponent.endsWith(".war")) {
            throw new UnsupportedOperationException(".war archives are not supported yet");
        }
        return this.getDirectoryIterator(classPathComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<String> getJarOrZipIterator(String jarname) throws Exception {
        ZipFile zip = new ZipFile(jarname);
        try {
            IConvertor<ZipEntry, String> zipToStringCollector = new IConvertor<ZipEntry, String>(){

                public String convert(ZipEntry zipentry) {
                    return zipentry.getName();
                }
            };
            IOpenIterator entries = OpenIterator.fromEnumeration(zip.entries());
            IOpenIterator iOpenIterator = entries.collect((IConvertor)zipToStringCollector).select(CLASSFILENAME_SELECTOR).collect((IConvertor)new FileNameToClassCollector(0, File.separatorChar));
            return iOpenIterator;
        }
        finally {
            zip.close();
        }
    }

    public void setClasspath(String[] string) {
        this.classpath = string;
    }

    static class JavaOpenClassHolder
    implements IOpenClassHolder {
        ClassLoader classLoader;
        String className;
        IOpenClass javaOpenClass;

        JavaOpenClassHolder(String className, ClassLoader classLoader) {
            this.className = className;
            this.classLoader = classLoader;
        }

        public String getDisplayName(int mode) {
            return this.javaOpenClass.getDisplayName(mode);
        }

        public String getName() {
            return this.className;
        }

        @Override
        public IOpenClass getOpenClass() {
            try {
                if (this.javaOpenClass == null) {
                    this.javaOpenClass = JavaOpenClass.getOpenClass(this.classLoader.loadClass(this.className));
                }
                return this.javaOpenClass;
            }
            catch (Exception ex) {
                throw RuntimeExceptionWrapper.wrap((Throwable)ex);
            }
        }
    }

    static class FileNameToClassCollector
    implements IConvertor<String, String> {
        int rootlength;
        char separator;

        FileNameToClassCollector(int rootlength, char separator) {
            this.rootlength = rootlength;
            this.separator = separator;
        }

        public String convert(String s) {
            s = s.substring(this.rootlength, s.length() - 6);
            int len = s.length();
            StringBuilder buf = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == this.separator) {
                    buf.append('.');
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }
    }

    static class ClassNameSelector
    extends ASelector<String> {
        ClassNameSelector() {
        }

        public boolean select(String name) {
            return name.endsWith(".class");
        }
    }
}

