/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;

public class PropertiesLocator {
    public static String findPropertyValue(String propertyName, String propertyFileName) {
        return PropertiesLocator.findPropertyValue(propertyName, propertyFileName, Thread.currentThread().getContextClassLoader(), new String[]{"."});
    }

    public static String findPropertyValue(String propertyName, String propertyFileName, ClassLoader loader, String[] fileRoots) {
        ConfigurableResourceContext cxt = new ConfigurableResourceContext(loader, fileRoots);
        return PropertiesLocator.findPropertyValue(propertyName, propertyFileName, cxt);
    }

    public static String findPropertyValue(String propertyName, String propertyFileName, IConfigurableResourceContext ucxt) {
        URL url = ucxt.findClassPathResource(propertyFileName);
        if (url != null) {
            InputStream is = null;
            try {
                is = url.openStream();
                Properties p = new Properties();
                p.load(is);
                String string = p.getProperty(propertyName);
                return string;
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Throwable t) {
                    Log.error((Object)"Error closing stream", (Throwable)t);
                }
            }
        }
        File f = ucxt.findFileSystemResource(propertyFileName);
        if (f != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                Properties p = new Properties();
                p.load(is);
                String string = p.getProperty(propertyName);
                return string;
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Throwable t) {
                    Log.error((Object)"Error closing stream", (Throwable)t);
                }
            }
        }
        return ucxt.findProperty(propertyName);
    }

    public static String locateFileOrURL(String fileName) {
        return PropertiesLocator.locateFileOrURL(fileName, Thread.currentThread().getContextClassLoader(), new String[]{"."});
    }

    public static String locateFileOrURL(String fileName, ClassLoader cl, String[] fileRoots) {
        ConfigurableResourceContext cxt = new ConfigurableResourceContext(cl, fileRoots);
        return PropertiesLocator.locateFileOrURL(fileName, cxt);
    }

    public static String locateFileOrURL(String fileName, IConfigurableResourceContext ucxt) {
        File f = ucxt.findFileSystemResource(fileName);
        if (f != null) {
            return f.getAbsolutePath();
        }
        URL url = ucxt.findClassPathResource(fileName);
        if (url != null) {
            return url.toExternalForm();
        }
        try {
            url = new URL(fileName);
            return fileName;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

