/*
 * Decompiled with CFR 0.152.
 */
package org.openl.vm;

import org.openl.IOpenDebugger;
import org.openl.IOpenRunner;
import org.openl.IOpenVM;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.runtime.IRuntimeContext;
import org.openl.util.fast.FastStack;
import org.openl.vm.IRuntimeEnv;

public class SimpleVM
implements IOpenVM {
    @Override
    public IOpenDebugger getDebugger() {
        return null;
    }

    @Override
    public IOpenRunner getRunner() {
        return new SimpleRunner();
    }

    @Override
    public IRuntimeEnv getRuntimeEnv() {
        return new SimpleRuntimeEnv();
    }

    public static class SimpleRuntimeEnv
    implements IRuntimeEnv {
        IOpenRunner runner;
        FastStack thisStack = new FastStack(100);
        FastStack frameStack = new FastStack(100);
        private FastStack contextStack = new FastStack(5);

        public SimpleRuntimeEnv() {
            this(new SimpleRunner(), 0, new Object[0]);
        }

        SimpleRuntimeEnv(IOpenRunner runner, int frameSize, Object[] params) {
            Object[] aLocalFrame = new Object[frameSize];
            this.runner = runner;
            System.arraycopy(params, 0, aLocalFrame, 0, params.length);
            this.pushLocalFrame(aLocalFrame);
        }

        public SimpleRuntimeEnv(SimpleRuntimeEnv env) {
            this();
            this.pushThis(env.getThis());
            this.pushContext(env.getContext());
            this.pushLocalFrame(env.getLocalFrame());
        }

        @Override
        public Object[] getLocalFrame() {
            return (Object[])this.frameStack.peek();
        }

        @Override
        public IOpenRunner getRunner() {
            return this.runner;
        }

        @Override
        public Object getThis() {
            if (this.thisStack.size() == 0) {
                return null;
            }
            return this.thisStack.peek();
        }

        @Override
        public Object[] popLocalFrame() {
            return (Object[])this.frameStack.pop();
        }

        @Override
        public Object popThis() {
            return this.thisStack.pop();
        }

        @Override
        public void pushLocalFrame(Object[] frame) {
            this.frameStack.push((Object)frame);
        }

        @Override
        public void pushThis(Object thisObject) {
            this.thisStack.push(thisObject);
        }

        @Override
        public IRuntimeContext getContext() {
            if (this.contextStack.size() > 0) {
                return (IRuntimeContext)this.contextStack.peek();
            }
            return null;
        }

        @Override
        public void setContext(IRuntimeContext context) {
            this.contextStack.clear();
            this.pushContext(context);
        }

        @Override
        public IRuntimeContext popContext() {
            if (this.contextStack.size() > 0) {
                return (IRuntimeContext)this.contextStack.pop();
            }
            throw new OpenlNotCheckedException("Failed to restore context. The context modification history is empty.");
        }

        @Override
        public void pushContext(IRuntimeContext context) {
            this.contextStack.push((Object)context);
        }

        @Override
        public boolean isContextManagingSupported() {
            return true;
        }

        @Override
        public IRuntimeEnv cloneEnvForMT() {
            return new SimpleRuntimeEnv(this);
        }
    }

    static class SimpleRunner
    implements IOpenRunner {
        SimpleRunner() {
        }

        @Override
        public Object run(IBoundMethodNode node, Object[] params) throws OpenLRuntimeException {
            int frameSize = node.getLocalFrameSize();
            return node.evaluate(new SimpleRuntimeEnv(this, frameSize, params));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run(IBoundMethodNode node, Object[] params, IRuntimeEnv env) throws OpenLRuntimeException {
            int frameSize = node.getLocalFrameSize();
            Object[] frame = new Object[frameSize];
            if (params != null && params.length > 0) {
                System.arraycopy(params, 0, frame, 0, params.length);
            }
            try {
                env.pushLocalFrame(frame);
                Object object = node.evaluate(env);
                return object;
            }
            finally {
                env.popLocalFrame();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object runExpression(IBoundNode expressionNode, Object[] params, IRuntimeEnv env) {
            try {
                env.pushLocalFrame(params);
                Object object = expressionNode.evaluate(env);
                return object;
            }
            finally {
                env.popLocalFrame();
            }
        }
    }
}

