/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.mapping.plugin.CmdLineArgs;

class CmdLineProcessor {
    private static final Log LOG = LogFactory.getLog(CmdLineProcessor.class);
    private static final String JAR_PATH_OPTION_LONG_NAME = "jar-path";
    private static final String JAR_PATH_OPTION_NAME = "jp";
    private static final String OUTPUT_XML_PATH_OPTION_LONG_NAME = "output-xml";
    private static final String OUTPUT_XML_PATH_OPTION_NAME = "o";
    private static final String TYPE_EXPORT_OPTION_LONG_NAME = "export-types";
    private static final String TYPE_EXPORT_OPTION_NAME = "t";
    private static final String TYPES_XML_PATH_OPTION_LONG_NAME = "types-xml";
    private static final String TYPES_XML_PATH_OPTION_NAME = "tx";
    private static final String MSG_EXPORT_OPTION_LONG_NAME = "export-messages";
    private static final String MSG_EXPORT_OPTION_NAME = "m";
    private static final String QUIET_REFLECTION_ERRORS_OPTION_LONG_NAME = "quiet-reflection-errors";
    private static final String QUIET_REFLECTION_ERRORS_OPTION_NAME = "qre";
    private static final String GENERATE_TYPES_OPTION_LONG_NAME = "generate-types";
    private static final String GENERATE_TYPES_OPTION_NAME = "g";
    private static final String HELP_OPTION_LONG_NAME = "help";
    private static final String HELP_OPTION_NAME = "h";
    private Options cmdOptions;

    CmdLineProcessor() {
    }

    public CmdLineArgs parse(String[] args) {
        CmdLineArgs cmdArgs = new CmdLineArgs();
        try {
            GnuParser cmdLineParser = new GnuParser();
            Options cmdOptions = this.getCmdOptions();
            CommandLine commandLine = cmdLineParser.parse(cmdOptions, args);
            if (commandLine.hasOption(JAR_PATH_OPTION_NAME)) {
                cmdArgs.setJarpath(commandLine.getOptionValue(JAR_PATH_OPTION_NAME));
            }
            if (commandLine.hasOption(OUTPUT_XML_PATH_OPTION_NAME)) {
                cmdArgs.setOutpath(commandLine.getOptionValue(OUTPUT_XML_PATH_OPTION_NAME));
            }
            if (commandLine.hasOption(TYPES_XML_PATH_OPTION_NAME)) {
                cmdArgs.setTypesXmlPath(commandLine.getOptionValue(TYPES_XML_PATH_OPTION_NAME));
            }
            cmdArgs.setHelp(commandLine.hasOption(HELP_OPTION_NAME));
            cmdArgs.setExportTypes(commandLine.hasOption(TYPE_EXPORT_OPTION_NAME));
            cmdArgs.setExportMessages(commandLine.hasOption(MSG_EXPORT_OPTION_NAME));
            cmdArgs.setQuietReflectionErrors(commandLine.hasOption(QUIET_REFLECTION_ERRORS_OPTION_NAME));
            cmdArgs.setGenerateTypes(commandLine.hasOption(GENERATE_TYPES_OPTION_NAME));
            if (!cmdArgs.hasHelpOption()) {
                if (commandLine.getArgs().length == 0) {
                    throw new RuntimeException("Source file is not defined");
                }
                if (commandLine.getArgs().length > 1) {
                    throw new RuntimeException("Cannot resolve source file");
                }
                cmdArgs.setSourcepath(commandLine.getArgs()[0]);
            }
        }
        catch (ParseException parseException) {
            LOG.error((Object)"Encountered exception while parsing command line arguments", (Throwable)parseException);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)cmdArgs.toString());
        }
        return cmdArgs;
    }

    private Options getCmdOptions() {
        if (this.cmdOptions == null) {
            OptionBuilder.withDescription((String)"output xml file path");
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)OUTPUT_XML_PATH_OPTION_LONG_NAME);
            Option out = OptionBuilder.create((String)OUTPUT_XML_PATH_OPTION_NAME);
            OptionBuilder.withDescription((String)"folders list which will be scanned to find jar files");
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)JAR_PATH_OPTION_LONG_NAME);
            Option jarpath = OptionBuilder.create((String)JAR_PATH_OPTION_NAME);
            OptionBuilder.withDescription((String)"print current message");
            OptionBuilder.withLongOpt((String)HELP_OPTION_LONG_NAME);
            Option help = OptionBuilder.create((String)HELP_OPTION_NAME);
            OptionBuilder.withDescription((String)"export types");
            OptionBuilder.withLongOpt((String)TYPE_EXPORT_OPTION_LONG_NAME);
            Option exportTypes = OptionBuilder.create((String)TYPE_EXPORT_OPTION_NAME);
            OptionBuilder.withDescription((String)"types xml file path");
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)TYPES_XML_PATH_OPTION_LONG_NAME);
            Option typesXmlPath = OptionBuilder.create((String)TYPES_XML_PATH_OPTION_NAME);
            OptionBuilder.withDescription((String)"export errors and warinings");
            OptionBuilder.withLongOpt((String)MSG_EXPORT_OPTION_LONG_NAME);
            Option exportMessages = OptionBuilder.create((String)MSG_EXPORT_OPTION_NAME);
            OptionBuilder.withDescription((String)"don't log errors loading classes from jars and getting their fields");
            OptionBuilder.withLongOpt((String)QUIET_REFLECTION_ERRORS_OPTION_LONG_NAME);
            Option quietReflectionErrors = OptionBuilder.create((String)QUIET_REFLECTION_ERRORS_OPTION_NAME);
            OptionBuilder.withDescription((String)"generate types xml");
            OptionBuilder.withLongOpt((String)GENERATE_TYPES_OPTION_LONG_NAME);
            Option generateTypesXml = OptionBuilder.create((String)GENERATE_TYPES_OPTION_NAME);
            this.cmdOptions = new Options();
            this.cmdOptions.addOption(out);
            this.cmdOptions.addOption(jarpath);
            this.cmdOptions.addOption(exportTypes);
            this.cmdOptions.addOption(typesXmlPath);
            this.cmdOptions.addOption(exportMessages);
            this.cmdOptions.addOption(quietReflectionErrors);
            this.cmdOptions.addOption(generateTypesXml);
            this.cmdOptions.addOption(help);
        }
        return this.cmdOptions;
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar org.openl.rules.mapping.dev.plugin-<version>.jar <openl_project_source> [options]", this.getCmdOptions());
    }
}

