/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin.serialize;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.util.CollectionUtils;
import org.dozer.util.ReflectionUtils;
import org.openl.rules.mapping.plugin.serialize.BeanEntry;
import org.openl.rules.mapping.plugin.serialize.CollectionType;
import org.openl.rules.mapping.plugin.serialize.FieldEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSerializer {
    private static final Log LOG = LogFactory.getLog(ClassSerializer.class);
    private static final String[] ignoredProperties = new String[]{"class"};

    public static BeanEntry serialize(Class<?> clazz, boolean quietReflectionErrors) {
        PropertyDescriptor[] propDescriptors;
        BeanEntry bean;
        block8: {
            if (clazz == null) {
                return null;
            }
            bean = new BeanEntry();
            bean.setName(clazz.getName());
            bean.setExtendedType(ClassSerializer.getSuperclass(clazz));
            propDescriptors = null;
            try {
                propDescriptors = ReflectionUtils.getPropertyDescriptors(clazz);
            }
            catch (Throwable e) {
                if (quietReflectionErrors) break block8;
                LOG.error((Object)String.format("An error has occured while loading properties of class '%s'", clazz.getName()), e);
            }
        }
        if (propDescriptors == null) {
            return bean;
        }
        ArrayList<FieldEntry> fields = new ArrayList<FieldEntry>(propDescriptors.length);
        for (PropertyDescriptor propDescriptor : propDescriptors) {
            if (ClassSerializer.isIgnoredProperty(propDescriptor.getName())) continue;
            try {
                Class<?> propertyType = propDescriptor.getPropertyType();
                if (propertyType == null) continue;
                FieldEntry field = new FieldEntry();
                field.setName(propDescriptor.getName());
                field.setType(propertyType);
                boolean isCollection = CollectionUtils.isCollection(propertyType);
                boolean isArray = CollectionUtils.isArray(propertyType);
                if (isCollection || isArray) {
                    field.setCollectionType(isArray ? CollectionType.ARRAY : CollectionType.COLLECTION);
                    field.setCollectionItemType(ReflectionUtils.getComponentType(propertyType, (PropertyDescriptor)propDescriptor, Object.class));
                }
                fields.add(field);
            }
            catch (Throwable e) {
                if (quietReflectionErrors) continue;
                LOG.error((Object)String.format("An error has occurred while processing property '%s' of class %s", propDescriptor.getName(), clazz.getName()), e);
            }
        }
        bean.setFields(fields);
        return bean;
    }

    public static List<BeanEntry> serialize(List<Class<?>> classes, boolean quietReflectionErrors) {
        ArrayList<BeanEntry> beans = new ArrayList<BeanEntry>(classes.size());
        for (Class<?> clazz : classes) {
            beans.add(ClassSerializer.serialize(clazz, quietReflectionErrors));
        }
        return beans;
    }

    private static Class<?> getSuperclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (Object.class == superclass) {
            return null;
        }
        return superclass;
    }

    private static boolean isIgnoredProperty(String propName) {
        for (String ignoredProperty : ignoredProperties) {
            if (!ignoredProperty.equals(propName)) continue;
            return true;
        }
        return false;
    }
}

