/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.mapping.plugin.util.FileUtils;
import org.springframework.util.AntPathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptorUtils {
    private static final Log LOG = LogFactory.getLog(AdaptorUtils.class);
    private static final String FILTER_DELIMITER = "\\|";
    private static final String PATH_DELIMITER = ";";
    private static final String JAR_FILE_EXTENSION = "jar";
    private static final String FILE_EXTENSION_DELIMITER = ".";
    private static final String JAR_FILE_SUFFIX = ".jar";

    private AdaptorUtils() {
    }

    public static URL[] scanDirs(String[] pathes) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : pathes) {
            String[] pathArgs = path.split(FILTER_DELIMITER);
            String dir = pathArgs[0];
            String filter = null;
            if (pathArgs.length > 1) {
                filter = pathArgs[1];
            }
            if (pathArgs.length > 2) {
                LOG.warn((Object)String.format("Only one filter expression can be applyed to path: %s", path));
            }
            urls.addAll(AdaptorUtils.scanDir(dir, filter));
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static List<URL> scanDir(String path, String filter) {
        File file;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Scanning dir: %s, filter: %s", path, StringUtils.defaultString((String)filter, (String)"null")));
        }
        if (!(file = new File(path)).exists()) {
            LOG.error((Object)String.format("File '%s' is not exist", path));
            return new ArrayList<URL>(0);
        }
        if (!file.isDirectory()) {
            LOG.error((Object)String.format("File '%s' is not a directory", path));
            return new ArrayList<URL>(0);
        }
        AntPathDirFilter dirFilter = new AntPathDirFilter(filter);
        List<File> dirs = FileUtils.listFiles(file, true, dirFilter);
        ArrayList<File> jarFiles = new ArrayList<File>();
        JarFileFilter jarFilter = new JarFileFilter();
        for (File dir : dirs) {
            List<File> jars = FileUtils.listFiles(dir, false, jarFilter);
            jarFiles.addAll(jars);
        }
        ArrayList<URL> jarURLs = new ArrayList<URL>(jarFiles.size());
        for (File jar : jarFiles) {
            try {
                URL url = jar.toURI().toURL();
                jarURLs.add(url);
                LOG.debug((Object)String.format("Found file: %s", url));
            }
            catch (MalformedURLException e) {
                LOG.error((Object)String.format("File '%s' is invalid", file.getName()), (Throwable)e);
            }
        }
        return jarURLs;
    }

    public static String[] getPaths(String paths) {
        if (StringUtils.isNotBlank((String)paths)) {
            return paths.split(PATH_DELIMITER);
        }
        return new String[0];
    }

    private static class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        public boolean accept(File arg) {
            return arg.isFile() && arg.getName().endsWith(AdaptorUtils.JAR_FILE_SUFFIX);
        }

        public String toString() {
            return "JarFileFilter [filter=isFile && endWith(\".jar\")]";
        }
    }

    private static class AntPathDirFilter
    implements FileFilter {
        private AntPathMatcher matcher = new AntPathMatcher();
        private String filter;

        public AntPathDirFilter(String filter) {
            this.filter = filter;
            this.matcher.setPathSeparator(System.getProperty("file.separator"));
        }

        public boolean accept(File arg) {
            if (arg.isFile()) {
                return false;
            }
            if (StringUtils.isNotBlank((String)this.filter)) {
                String path = arg.toURI().getPath();
                return this.matcher.match(this.filter, path.substring(0, path.length() - 1));
            }
            return true;
        }

        public String toString() {
            return "AntPathDirFilter [filter=" + this.filter + "]";
        }
    }
}

