/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.plugin.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private FileUtils() {
    }

    public static List<File> listFiles(File root, boolean recursive, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        if (root == null) {
            return files;
        }
        if (filter == null || filter.accept(root)) {
            files.add(root);
        }
        files.addAll(FileUtils.internalListFiles(root, recursive, filter));
        return files;
    }

    private static List<File> internalListFiles(File root, boolean recursive, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        File[] rootFiles = root.listFiles();
        if (rootFiles != null) {
            for (File file : rootFiles) {
                if (filter == null || filter.accept(file)) {
                    files.add(file);
                }
                if (!file.isDirectory() || !recursive) continue;
                files.addAll(FileUtils.internalListFiles(file, recursive, filter));
            }
        }
        return files;
    }
}

