/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar;

import java.util.Stack;

public class BracketMatcher {
    public static final String UNEXPECTED = "Unexpected";
    public static final String MISMATCHED = "Mismatched";
    public static final String UNMATCHED = "Unmatched";
    Stack<BracketsStackObject> stack = new Stack();

    public BracketsStackObject addToken(String image, Object id) {
        char c = image.charAt(0);
        Brackets b = Brackets.isBracket(c);
        if (b == null) {
            return null;
        }
        if (b.isOpen(c)) {
            this.stack.push(new BracketsStackObject(b, id));
            return null;
        }
        if (b.isClosed(c)) {
            if (this.stack.size() == 0) {
                return new BracketsStackObject(b, id, UNEXPECTED);
            }
            BracketsStackObject bso = this.stack.pop();
            if (bso.bracket.isClosed(c)) {
                return null;
            }
            bso.errorCode = MISMATCHED;
            return bso;
        }
        throw new RuntimeException("Wrong  bracket - cannot happen!!!");
    }

    public BracketsStackObject checkAtTheEnd() {
        if (this.stack.size() == 0) {
            return null;
        }
        BracketsStackObject bso = this.stack.pop();
        bso.errorCode = UNMATCHED;
        return bso;
    }

    public static class BracketsStackObject {
        Brackets bracket;
        Object id;
        String errorCode;

        public Brackets getBracket() {
            return this.bracket;
        }

        public Object getId() {
            return this.id;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public BracketsStackObject(Brackets bracket, Object id, String errorCode) {
            this.bracket = bracket;
            this.id = id;
            this.errorCode = errorCode;
        }

        public BracketsStackObject(Brackets bracket, Object id) {
            this.bracket = bracket;
            this.id = id;
        }
    }

    static enum Brackets {
        ROUND("()"),
        CURLY("{}"),
        SQUARE("[]");

        private String brackets;

        private Brackets(String brackets) {
            this.brackets = brackets;
        }

        boolean isOpen(char c) {
            return c == this.brackets.charAt(0);
        }

        boolean isClosed(char c) {
            return c == this.brackets.charAt(1);
        }

        static Brackets isBracket(char c) {
            for (int i = 0; i < Brackets.values().length; ++i) {
                Brackets test = Brackets.values()[i];
                if (!test.isClosed(c) && !test.isOpen(c)) continue;
                return test;
            }
            return null;
        }
    }
}

