/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.FieldUsageSearcher;
import org.openl.binding.impl.MethodUsagesSearcher;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageComparator;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.engine.OpenLCodeManager;
import org.openl.engine.OpenLCompileManager;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.CompositeSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;

public class OpenLCellExpressionsCompiler {
    public static void compileMethod(OpenL openl, IOpenSourceCodeModule source, CompositeMethod compositeMethod, IBindingContext bindingContext) {
        OpenLCompileManager compileManager = new OpenLCompileManager(openl);
        compileManager.compileMethod(source, compositeMethod, bindingContext);
        if (!bindingContext.isExecutionMode()) {
            OpenLCellExpressionsCompiler.gatherMetaInfo(source, compositeMethod);
        }
    }

    public static CompositeMethod makeMethod(OpenL openl, IOpenSourceCodeModule source, IOpenMethodHeader methodHeader, IBindingContext bindingContext) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        CompositeMethod method = codeManager.makeMethod(source, methodHeader, bindingContext);
        if (!bindingContext.isExecutionMode()) {
            OpenLCellExpressionsCompiler.gatherMetaInfo(source, method);
        }
        return method;
    }

    public static CompositeMethod makeMethodWithUnknownType(OpenL openl, IOpenSourceCodeModule source, String methodName, IMethodSignature signature, IOpenClass declaringClass, IBindingContext bindingContext) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        CompositeMethod method = codeManager.makeMethodWithUnknownType(source, methodName, signature, declaringClass, bindingContext);
        if (!bindingContext.isExecutionMode()) {
            OpenLCellExpressionsCompiler.gatherMetaInfo(source, method);
        }
        return method;
    }

    public static void gatherMetaInfo(IOpenSourceCodeModule source, CompositeMethod method) {
        int startIndex = 0;
        if (source instanceof CompositeSourceCodeModule) {
            OpenLCellExpressionsCompiler.setMetaInfoForCompositeSource(method, (CompositeSourceCodeModule)source, startIndex);
        } else {
            IOpenSourceCodeModule src = source;
            while (src instanceof SubTextSourceCodeModule) {
                startIndex += src.getStartPosition();
                src = ((SubTextSourceCodeModule)src).getBaseModule();
            }
            if (src instanceof GridCellSourceCodeModule) {
                ArrayList<NodeUsage> nodeUsages = new ArrayList<NodeUsage>(MethodUsagesSearcher.findAllMethods((IBoundNode)method.getMethodBodyBoundNode(), source.getCode(), startIndex));
                FieldUsageSearcher.findAllFields(nodeUsages, (IBoundNode)method.getMethodBodyBoundNode(), source.getCode(), startIndex);
                Collections.sort(nodeUsages, new NodeUsageComparator());
                OpenLCellExpressionsCompiler.setCellMetaInfo((GridCellSourceCodeModule)src, nodeUsages);
            }
        }
    }

    private static void setMetaInfoForCompositeSource(CompositeMethod method, CompositeSourceCodeModule source, int startIndex) {
        ArrayList<NodeUsage> nodeUsages = new ArrayList<NodeUsage>(MethodUsagesSearcher.findAllMethods((IBoundNode)method.getMethodBodyBoundNode(), source.getCode(), startIndex));
        FieldUsageSearcher.findAllFields(nodeUsages, (IBoundNode)method.getMethodBodyBoundNode(), source.getCode(), startIndex);
        IOpenSourceCodeModule[] modules = source.getModules();
        int moduleStart = 0;
        for (IOpenSourceCodeModule module : modules) {
            int moduleEnd = moduleStart + module.getCode().length();
            if (module instanceof GridCellSourceCodeModule) {
                GridCellSourceCodeModule cellSource = (GridCellSourceCodeModule)module;
                ArrayList<NodeUsage> currentCellMethodUsages = new ArrayList<NodeUsage>();
                for (NodeUsage usage : nodeUsages) {
                    if (usage.getStart() < moduleStart || usage.getEnd() > moduleEnd) continue;
                    if (usage instanceof MethodUsagesSearcher.MethodUsage) {
                        currentCellMethodUsages.add(new MethodUsagesSearcher.MethodUsage(usage.getStart() - moduleStart, usage.getEnd() - moduleStart, ((MethodUsagesSearcher.MethodUsage)usage).getMethod()));
                        continue;
                    }
                    currentCellMethodUsages.add(new SimpleNodeUsage(usage.getStart() - moduleStart, usage.getEnd() - moduleStart, usage.getDescription(), usage.getUri(), usage.getNodeType()));
                }
                Collections.sort(currentCellMethodUsages, new NodeUsageComparator());
                OpenLCellExpressionsCompiler.setCellMetaInfo(cellSource, currentCellMethodUsages);
            }
            moduleStart = moduleEnd + 1;
        }
    }

    private static void setCellMetaInfo(GridCellSourceCodeModule src, List<NodeUsage> methodUsages) {
        ICell cell = src.getCell();
        if (!CollectionUtils.isEmpty(methodUsages) && cell != null) {
            cell.setMetaInfo(new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, methodUsages));
        }
    }
}

