/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.Map;
import org.openl.util.BooleanUtils;

public class OpenLSystemProperties {
    public static final String CUSTOM_SPREADSHEET_TYPE_PROPERTY = "custom.spreadsheet.type";
    public static final String RUN_TESTS_IN_PARALLEL = "test.run.parallel";
    public static final String TEST_RUN_THREAD_COUNT_PROPERTY = "test.run.thread.count";
    public static final String DISPATCHING_MODE_PROPERTY = "dispatching.mode";
    public static final String DISPATCHING_VALIDATION = "dispatching.validation";
    public static final String DISPATCHING_MODE_JAVA = "java";
    public static final String DISPATCHING_MODE_DT = "dt";

    private OpenLSystemProperties() {
    }

    public static boolean isJavaDispatchingMode() {
        String dispatchingMode = System.getProperty(DISPATCHING_MODE_PROPERTY);
        return dispatchingMode != null && dispatchingMode.equalsIgnoreCase(DISPATCHING_MODE_JAVA);
    }

    public static boolean isDTDispatchingMode() {
        String dispatchingMode = System.getProperty(DISPATCHING_MODE_PROPERTY);
        return dispatchingMode != null && dispatchingMode.equalsIgnoreCase(DISPATCHING_MODE_DT);
    }

    public static boolean isCustomSpreadsheetType() {
        String customSpreadsheetType = System.getProperty(CUSTOM_SPREADSHEET_TYPE_PROPERTY);
        return BooleanUtils.toBoolean((Object)customSpreadsheetType);
    }

    public static boolean isJavaDispatchingMode(Map<String, Object> externalParameters) {
        String dispatchingMode = null;
        dispatchingMode = externalParameters != null && externalParameters.containsKey(DISPATCHING_MODE_PROPERTY) ? externalParameters.get(DISPATCHING_MODE_PROPERTY).toString() : System.getProperty(DISPATCHING_MODE_PROPERTY);
        return dispatchingMode != null && dispatchingMode.equalsIgnoreCase(DISPATCHING_MODE_JAVA);
    }

    public static boolean isDTDispatchingMode(Map<String, Object> externalParameters) {
        String dispatchingMode = null;
        dispatchingMode = externalParameters != null && externalParameters.containsKey(DISPATCHING_MODE_PROPERTY) ? externalParameters.get(DISPATCHING_MODE_PROPERTY).toString() : System.getProperty(DISPATCHING_MODE_PROPERTY);
        return dispatchingMode != null && dispatchingMode.equalsIgnoreCase(DISPATCHING_MODE_DT);
    }

    public static boolean isDispatchingValidationEnabled(Map<String, Object> externalParameters) {
        String dispatchingValidation = null;
        dispatchingValidation = externalParameters != null && externalParameters.containsKey(DISPATCHING_VALIDATION) ? externalParameters.get(DISPATCHING_VALIDATION).toString() : System.getProperty(DISPATCHING_VALIDATION);
        return BooleanUtils.toBoolean((Object)dispatchingValidation);
    }

    public static boolean isRunTestsInParallel(Map<String, Object> externalParameters) {
        String runTestsInParallel = externalParameters != null && externalParameters.containsKey(RUN_TESTS_IN_PARALLEL) ? externalParameters.get(RUN_TESTS_IN_PARALLEL).toString() : System.getProperty(RUN_TESTS_IN_PARALLEL);
        return BooleanUtils.toBoolean((Object)runTestsInParallel);
    }

    public static int getTestRunThreadCount(Map<String, Object> externalParameters) {
        String property;
        Integer testRunTheadCount = null;
        testRunTheadCount = externalParameters != null && externalParameters.containsKey(TEST_RUN_THREAD_COUNT_PROPERTY) ? Integer.valueOf(externalParameters.get(TEST_RUN_THREAD_COUNT_PROPERTY).toString()) : Integer.valueOf((property = System.getProperty(TEST_RUN_THREAD_COUNT_PROPERTY)) != null ? Integer.valueOf(property) : 4);
        return testRunTheadCount;
    }

    public static String getDispatchingMode(Map<String, Object> externalParameters) {
        String dispatchingMode = null;
        dispatchingMode = externalParameters != null && externalParameters.containsKey(DISPATCHING_MODE_PROPERTY) ? externalParameters.get(DISPATCHING_MODE_PROPERTY).toString() : System.getProperty(DISPATCHING_MODE_PROPERTY);
        return dispatchingMode;
    }

    public static boolean isCustomSpreadsheetType(Map<String, Object> externalParameters) {
        String customSpreadsheetType = null;
        customSpreadsheetType = externalParameters != null && externalParameters.containsKey(CUSTOM_SPREADSHEET_TYPE_PROPERTY) ? externalParameters.get(CUSTOM_SPREADSHEET_TYPE_PROPERTY).toString() : System.getProperty(CUSTOM_SPREADSHEET_TYPE_PROPERTY);
        if (customSpreadsheetType == null || customSpreadsheetType.equals("")) {
            return true;
        }
        return BooleanUtils.toBoolean((Object)customSpreadsheetType);
    }
}

