/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLSystemProperties;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetBuilder;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;

public class SpreadsheetBoundNode
extends AMethodBasedNode
implements IMemberBoundNode {
    private SpreadsheetBuilder builder;

    public SpreadsheetBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    protected Spreadsheet createSpreadsheet() {
        boolean isCustomSpreadsheetType = this.getType().getInstanceClass().equals(SpreadsheetResult.class) && OpenLSystemProperties.isCustomSpreadsheetType(this.builder.getBindingContext().getExternalParams());
        return new Spreadsheet(this.getHeader(), this, isCustomSpreadsheetType);
    }

    @Override
    protected ExecutableRulesMethod createMethodShell() {
        Spreadsheet spreadsheet = this.createSpreadsheet();
        spreadsheet.setSpreadsheetType(this.builder.getPopulatedSpreadsheetOpenClass());
        if (spreadsheet.isCustomSpreadsheetType()) {
            IOpenClass type = null;
            try {
                type = spreadsheet.getType();
                this.builder.getBindingContext().addType("org.openl.this", type);
            }
            catch (Exception e) {
                String message = String.format("Cannot add type %s to the binding context", type != null ? type.getName() : spreadsheet.getName());
                SyntaxNodeException exception = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
                this.getTableSyntaxNode().addError(exception);
                BindHelper.processError((SyntaxNodeException)exception, (IBindingContext)this.builder.getBindingContext());
            }
        }
        return spreadsheet;
    }

    private void initSpreadsheetBuilder(IBindingContext bindingContext) throws SyntaxNodeException {
        TableSyntaxNode tableSyntaxNode = this.getTableSyntaxNode();
        this.validateTableBody(tableSyntaxNode.getTableBody());
        IOpenMethodHeader header = this.getHeader();
        SpreadsheetBuilder spreadsheetBuilder = new SpreadsheetBuilder(tableSyntaxNode, bindingContext, header);
        this.setSpreadsheetBuilder(spreadsheetBuilder);
    }

    public void preBind(IBindingContext bindingContext) throws SyntaxNodeException {
        this.initSpreadsheetBuilder(bindingContext);
        this.builder.populateSpreadsheetOpenClass();
    }

    @Override
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        super.finalizeBind(bindingContext);
        ILogicalTable tableBody = this.getTableSyntaxNode().getTableBody();
        this.getTableSyntaxNode().getSubTables().put("business", tableBody);
        this.builder.finalizeBuild(this.getSpreadsheet());
    }

    private void validateTableBody(ILogicalTable tableBody) throws SyntaxNodeException {
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Table has no body! Try to merge header cell horizontally to identify table.", (ISyntaxNode)this.getTableSyntaxNode());
        }
        int height = tableBody.getHeight();
        int width = tableBody.getWidth();
        if (height < 2 || width < 2) {
            String message = String.format("Spreadsheet must have at least 2x2 cells! Actual size %dx%d.", width, height);
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)this.getTableSyntaxNode());
        }
    }

    public Spreadsheet getSpreadsheet() {
        return (Spreadsheet)this.getMethod();
    }

    public SpreadsheetBuilder getSpreadsheetBuilder() {
        return this.builder;
    }

    public void setSpreadsheetBuilder(SpreadsheetBuilder spreadsheetBuilder) {
        this.builder = spreadsheetBuilder;
    }

    public void updateDependency(BindingDependencies dependencies) {
        if (this.getSpreadsheet().getCells() != null) {
            for (SpreadsheetCell[] cellArray : this.getSpreadsheet().getCells()) {
                if (cellArray == null) continue;
                for (SpreadsheetCell cell : cellArray) {
                    CompositeMethod method;
                    if (cell == null || (method = (CompositeMethod)cell.getMethod()) == null) continue;
                    method.updateDependency(dependencies);
                }
            }
        }
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode()) {
            super.removeDebugInformation(cxt);
            this.getSpreadsheetBuilder().removeDebugInformation();
            this.setSpreadsheetBuilder(null);
        }
    }
}

