/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SpreadsheetStructureBuilder;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.types.IOpenMethodHeader;

public class SpreadsheetBuilder {
    private SpreadsheetStructureBuilder structureBuilder;
    private IBindingContext bindingContext;
    private SpreadsheetOpenClass spreadsheetOpenClass;

    public SpreadsheetBuilder(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext, IOpenMethodHeader header) {
        this.bindingContext = bindingContext;
        OpenL openl = bindingContext.getOpenL();
        String type = header.getName() + "Type";
        this.spreadsheetOpenClass = new SpreadsheetOpenClass(type, openl);
        Boolean autoType = tableSyntaxNode.getTableProperties().getAutoType();
        this.structureBuilder = new SpreadsheetStructureBuilder(tableSyntaxNode, bindingContext, header, autoType);
    }

    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void populateSpreadsheetOpenClass() {
        this.structureBuilder.addCellFields(this.spreadsheetOpenClass);
    }

    public void finalizeBuild(Spreadsheet spreadsheet) {
        spreadsheet.setRowNames(this.structureBuilder.getRowNames());
        spreadsheet.setColumnNames(this.structureBuilder.getColumnNames());
        spreadsheet.setCells(this.structureBuilder.getCells());
        spreadsheet.setResultBuilder(this.structureBuilder.getResultBuilder(spreadsheet));
    }

    public void removeDebugInformation() throws Exception {
        this.structureBuilder.getSpreadsheetStructureBuilderHolder().clear();
    }

    public SpreadsheetOpenClass getPopulatedSpreadsheetOpenClass() {
        return this.spreadsheetOpenClass;
    }
}

