/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.NodeType;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.StringValue;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetSymbols;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.ArrayResultBuilder;
import org.openl.rules.calc.result.DefaultResultBuilder;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.calc.result.ScalarResultBuilder;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.generation.JavaClassGeneratorHelper;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.openl.util.text.TextInterval;

public class SpreadsheetComponentsBuilder {
    private TableSyntaxNode tableSyntaxNode;
    private IBindingContext bindingContext;
    private CellsHeaderExtractor cellsHeaderExtractor;
    private SpreadsheetHeaderDefinition returnHeaderDefinition;
    private Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private Map<String, SpreadsheetHeaderDefinition> headerDefinitions = new HashMap<String, SpreadsheetHeaderDefinition>();

    public SpreadsheetComponentsBuilder(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) {
        this.tableSyntaxNode = tableSyntaxNode;
        CellsHeaderExtractor extractor = ((SpreadsheetHeaderNode)tableSyntaxNode.getHeader()).getCellHeadersExtractor();
        if (extractor == null) {
            extractor = new CellsHeaderExtractor(this.getSignature(tableSyntaxNode), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getRow(0)).getColumns(1), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getColumn(0)).getRows(1));
        }
        this.cellsHeaderExtractor = extractor;
        this.bindingContext = bindingContext;
    }

    public Map<Integer, SpreadsheetHeaderDefinition> getRowHeaders() {
        return new HashMap<Integer, SpreadsheetHeaderDefinition>(this.rowHeaders);
    }

    public Map<Integer, SpreadsheetHeaderDefinition> getColumnHeaders() {
        return new HashMap<Integer, SpreadsheetHeaderDefinition>(this.columnHeaders);
    }

    public CellsHeaderExtractor getCellsHeadersExtractor() {
        return this.cellsHeaderExtractor;
    }

    public void buildHeaders(IOpenClass spreadsheetHeaderType) {
        this.addRowHeaders();
        this.addColumnHeaders();
        this.buildHeaderDefinitionsTypes();
        try {
            this.buildReturnCells(spreadsheetHeaderType);
        }
        catch (SyntaxNodeException e) {
            this.getTableSyntaxNode().addError(e);
            BindHelper.processError((SyntaxNodeException)e, (IBindingContext)this.getBindingContext());
        }
    }

    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public IResultBuilder buildResultBuilder(Spreadsheet spreadsheet) {
        IResultBuilder resultBuilder = null;
        try {
            resultBuilder = this.getResultBuilderInternal(spreadsheet);
        }
        catch (SyntaxNodeException e) {
            this.tableSyntaxNode.addError(e);
            BindHelper.processError((SyntaxNodeException)e, (IBindingContext)this.bindingContext);
        }
        return resultBuilder;
    }

    private void addRowHeaders() {
        String[] rowNames = this.cellsHeaderExtractor.getRowNames();
        for (int i = 0; i < rowNames.length; ++i) {
            StringValue rowName = this.cellsHeaderExtractor.getRowNameForHeader(rowNames[i], i, this.bindingContext);
            if (rowName == null) continue;
            this.addRowHeader(i, rowName);
        }
    }

    private void addColumnHeaders() {
        String[] columnNames = this.cellsHeaderExtractor.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            StringValue columnName = this.cellsHeaderExtractor.getColumnNameForHeader(columnNames[i], i, this.bindingContext);
            if (columnName == null) continue;
            this.addColumnHeader(i, columnName);
        }
    }

    private void addColumnHeader(int column, StringValue value) {
        SpreadsheetHeaderDefinition header = this.columnHeaders.get(column);
        if (header == null) {
            header = new SpreadsheetHeaderDefinition(-1, column);
            this.columnHeaders.put(column, header);
        }
        this.parseHeader(header, value);
    }

    private void addRowHeader(int row, StringValue value) {
        SpreadsheetHeaderDefinition header = this.rowHeaders.get(row);
        if (header == null) {
            header = new SpreadsheetHeaderDefinition(row, -1);
            this.rowHeaders.put(row, header);
        }
        this.parseHeader(header, value);
    }

    private void parseHeader(SpreadsheetHeaderDefinition header, StringValue value) {
        try {
            SymbolicTypeDefinition parsed = this.parseHeaderElement(value);
            String headerName = parsed.getName().getIdentifier();
            SpreadsheetHeaderDefinition h1 = this.headerDefinitions.get(headerName);
            if (h1 != null) {
                throw new DuplicatedVarException(null, headerName);
            }
            this.headerDefinitions.put(headerName, header);
            header.addVarHeader(parsed);
        }
        catch (SyntaxNodeException error) {
            this.tableSyntaxNode.addError(error);
            BindHelper.processError((SyntaxNodeException)error, (IBindingContext)this.bindingContext);
        }
        catch (Throwable t) {
            SyntaxNodeException error;
            try {
                error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse spreadsheet header definition", (Throwable)t, (ISyntaxNode)this.parseHeaderElement(value).getName());
            }
            catch (SyntaxNodeException e) {
                error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse spreadsheet header definition", (Throwable)t, null, (IOpenSourceCodeModule)value.asSourceCodeModule());
            }
            this.tableSyntaxNode.addError(error);
            BindHelper.processError((SyntaxNodeException)error, (IBindingContext)this.bindingContext);
        }
    }

    private SymbolicTypeDefinition parseHeaderElement(StringValue value) throws SyntaxNodeException {
        IdentifierNode[] nodes;
        IOpenSourceCodeModule source = value.asSourceCodeModule();
        try {
            nodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)SpreadsheetSymbols.TYPE_DELIMETER.toString());
        }
        catch (OpenLCompilationException e) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot parse header", (IOpenSourceCodeModule)source);
        }
        switch (nodes.length) {
            case 1: {
                return new SymbolicTypeDefinition(nodes[0], null);
            }
            case 2: {
                return new SymbolicTypeDefinition(nodes[0], nodes[1]);
            }
        }
        String message = String.format("Valid header format: name [%s type]", SpreadsheetSymbols.TYPE_DELIMETER.toString());
        if (nodes.length > 2) {
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)nodes[2]);
        }
        TextInterval location = LocationUtils.createTextInterval((StringValue)value);
        throw SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)location, (IOpenSourceCodeModule)source);
    }

    private void buildHeaderDefinitionsTypes() {
        for (SpreadsheetHeaderDefinition headerDefinition : this.headerDefinitions.values()) {
            IOpenClass headerType = null;
            IdentifierNode typeIdentifierNode = null;
            for (SymbolicTypeDefinition symbolicTypeDefinition : headerDefinition.getVars()) {
                typeIdentifierNode = symbolicTypeDefinition.getType();
                if (typeIdentifierNode == null) continue;
                SyntaxNodeException error = null;
                String typeIdentifier = typeIdentifierNode.getIdentifier();
                IOpenClass type = this.findType(typeIdentifier);
                if (type == null) {
                    String message = "Type not found: " + typeIdentifier;
                    error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)typeIdentifierNode);
                } else if (headerType == null) {
                    headerType = type;
                } else if (headerType != type) {
                    error = SyntaxNodeExceptionUtils.createError((String)"Type redefinition", (ISyntaxNode)typeIdentifierNode);
                }
                if (error == null) continue;
                this.tableSyntaxNode.addError(error);
                BindHelper.processError((SyntaxNodeException)error, (IBindingContext)this.bindingContext);
            }
            if (headerType == null) continue;
            headerDefinition.setType(headerType);
            if (this.bindingContext.isExecutionMode() || typeIdentifierNode == null) continue;
            IOpenClass type = headerType;
            while (type.getMetaInfo() == null && type.isArray()) {
                type = type.getComponentClass();
            }
            IdentifierNode identifier = this.cutTypeIdentifier(typeIdentifierNode);
            if (identifier == null) continue;
            ILogicalTable cell = headerDefinition.getRow() >= 0 ? (ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(headerDefinition.getRow()) : (ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(headerDefinition.getColumn());
            RuleRowHelper.setCellMetaInfoWithNodeUsage(cell, identifier, type.getMetaInfo(), NodeType.DATATYPE);
        }
    }

    private IdentifierNode cutTypeIdentifier(IdentifierNode typeIdentifierNode) {
        try {
            IdentifierNode[] nodes;
            IdentifierNode[] variableAndType = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)SpreadsheetSymbols.TYPE_DELIMETER.toString());
            if (variableAndType.length > 1 && (nodes = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)" []\n\r", (ILocation)variableAndType[1].getLocation())).length > 0) {
                return nodes[0];
            }
        }
        catch (OpenLCompilationException e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse header", (ISyntaxNode)typeIdentifierNode);
            this.getTableSyntaxNode().addError(error);
            BindHelper.processError((SyntaxNodeException)error, (IBindingContext)this.getBindingContext());
        }
        return null;
    }

    private IOpenClass findType(String typeIdentifier) {
        IOpenClass result;
        if (JavaClassGeneratorHelper.isArray((String)typeIdentifier)) {
            String cleanTypeIdentifier = JavaClassGeneratorHelper.cleanTypeName((String)typeIdentifier);
            IOpenClass type = this.bindingContext.findType("org.openl.this", cleanTypeIdentifier);
            if (type == null) {
                return null;
            }
            int typeDimension = JavaClassGeneratorHelper.getDimension((String)typeIdentifier);
            result = type.getAggregateInfo().getIndexedAggregateType(type, typeDimension);
        } else {
            result = this.bindingContext.findType("org.openl.this", typeIdentifier);
        }
        return result;
    }

    private void buildReturnCells(IOpenClass spreadsheetHeaderType) throws SyntaxNodeException {
        SpreadsheetHeaderDefinition headerDefinition = this.headerDefinitions.get(SpreadsheetSymbols.RETURN_NAME.toString());
        if (headerDefinition == null) {
            return;
        }
        int nonEmptyCellsCount = this.calculateNonEmptyCells(headerDefinition);
        IOpenClass cellType = this.deriveSingleCellReturnType(nonEmptyCellsCount, headerDefinition, spreadsheetHeaderType);
        if (headerDefinition.getType() != null) {
            String message = String.format("RETURN %s derives it's type from the Spreadsheet return type and therefore must not be defined here", headerDefinition.rowOrColumn());
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)headerDefinition.getVars().get(0).getName());
        }
        headerDefinition.setType(cellType);
        this.returnHeaderDefinition = headerDefinition;
    }

    private int calculateNonEmptyCells(SpreadsheetHeaderDefinition headerDefinition) {
        int fromRow = 0;
        int toRow = this.cellsHeaderExtractor.getHeight();
        int fromColumn = 0;
        int toColumn = this.cellsHeaderExtractor.getWidth();
        if (headerDefinition.isRow()) {
            fromRow = headerDefinition.getRow();
            toRow = fromRow + 1;
        } else {
            fromColumn = headerDefinition.getColumn();
            toColumn = fromColumn + 1;
        }
        int nonEmptyCellsCount = 0;
        for (int columnIndex = fromColumn; columnIndex < toColumn; ++columnIndex) {
            for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
                ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(columnIndex));
                String value = cell.getSource().getCell(0, 0).getStringValue();
                if (value == null || value.trim().length() <= 0) continue;
                ++nonEmptyCellsCount;
            }
        }
        return nonEmptyCellsCount;
    }

    private IOpenClass deriveSingleCellReturnType(int cellsCount, SpreadsheetHeaderDefinition headerDefinition, IOpenClass spreadsheetHeaderType) throws SyntaxNodeException {
        IOpenClass returnType = spreadsheetHeaderType;
        if (cellsCount < 2) {
            return returnType;
        }
        IAggregateInfo aggregateInfo = returnType.getAggregateInfo();
        if (aggregateInfo == null || aggregateInfo.getComponentType(returnType) == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"The return type is scalar, but there are more than one return cells", (ISyntaxNode)headerDefinition.findVarDef(SpreadsheetSymbols.RETURN_NAME.toString()).getName());
        }
        returnType = aggregateInfo.getComponentType(returnType);
        return returnType;
    }

    private boolean isExistsReturnHeader() {
        return this.returnHeaderDefinition != null;
    }

    private IResultBuilder getResultBuilderInternal(Spreadsheet spreadsheet) throws SyntaxNodeException {
        IResultBuilder resultBuilder;
        SymbolicTypeDefinition symbolicTypeDefinition = null;
        if (this.isExistsReturnHeader()) {
            symbolicTypeDefinition = this.returnHeaderDefinition.findVarDef(SpreadsheetSymbols.RETURN_NAME.toString());
        }
        if (spreadsheet.getHeader().getType() == JavaOpenClass.VOID) {
            throw SyntaxNodeExceptionUtils.createError((String)"Spreadsheet can not return 'void' type", (ISyntaxNode)this.tableSyntaxNode);
        }
        if (spreadsheet.getHeader().getType() == JavaOpenClass.getOpenClass(SpreadsheetResult.class)) {
            if (this.isExistsReturnHeader()) {
                throw SyntaxNodeExceptionUtils.createError((String)"If Spreadsheet return type is SpreadsheetResult, no return type is allowed", (ISyntaxNode)(symbolicTypeDefinition == null ? null : symbolicTypeDefinition.getName()));
            }
            resultBuilder = new DefaultResultBuilder();
        } else {
            if (!this.isExistsReturnHeader()) {
                throw SyntaxNodeExceptionUtils.createError((String)"There should be RETURN row or column for this return type", (ISyntaxNode)this.tableSyntaxNode);
            }
            List<SpreadsheetCell> notEmptyReturnDefinitions = spreadsheet.listNonEmptyCells(this.returnHeaderDefinition);
            switch (notEmptyReturnDefinitions.size()) {
                case 0: {
                    throw SyntaxNodeExceptionUtils.createError((String)"There is no return expression cell", (ISyntaxNode)(symbolicTypeDefinition == null ? null : symbolicTypeDefinition.getName()));
                }
                case 1: {
                    resultBuilder = new ScalarResultBuilder(notEmptyReturnDefinitions);
                    break;
                }
                default: {
                    resultBuilder = new ArrayResultBuilder(notEmptyReturnDefinitions, this.returnHeaderDefinition.getType());
                }
            }
        }
        return resultBuilder;
    }

    private String getSignature(TableSyntaxNode table) {
        return table.getHeader().getHeaderToken().getModule().getCode();
    }
}

