/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Map;
import org.openl.binding.IBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.types.IDynamicObject;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class SpreadsheetResultCalculator
implements IDynamicObject {
    public static final Object NEED_TO_CALCULATE_VALUE = new Object();
    public static final Object EMPTY_CELL = new Object();
    private Spreadsheet spreadsheet;
    protected IDynamicObject targetModule;
    protected Object[] params;
    protected IRuntimeEnv env;
    private Object[][] results;

    public SpreadsheetResultCalculator(Spreadsheet spreadsheet, IDynamicObject targetModule, Object[] params, IRuntimeEnv env, Object[][] preCalculatedResult) {
        this.spreadsheet = spreadsheet;
        this.targetModule = targetModule;
        this.params = params;
        this.env = env;
        this.results = preCalculatedResult == null ? new Object[spreadsheet.getHeight()][spreadsheet.getWidth()] : this.clonePrecalculatedResults(preCalculatedResult);
    }

    private Object[][] clonePrecalculatedResults(Object[][] preCalculatedResult) {
        Object[][] res = (Object[][])preCalculatedResult.clone();
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Object[])preCalculatedResult[i].clone();
        }
        return res;
    }

    public String getColumnName(int column) {
        return this.spreadsheet.getColumnNames()[column];
    }

    public Object getFieldValue(String name) {
        IOpenField field = this.spreadsheet.getSpreadsheetType().getField(name);
        if (field == null) {
            return this.targetModule.getFieldValue(name);
        }
        SpreadsheetCellField cellField = (SpreadsheetCellField)field;
        int row = cellField.getCell().getRowIndex();
        int column = cellField.getCell().getColumnIndex();
        return this.getValue(row, column);
    }

    public Map<String, Object> getFieldValues() {
        throw new UnsupportedOperationException("Should not be called, this is only used in NicePrinter");
    }

    public Object getRow(int row, IRuntimeEnv env) {
        return null;
    }

    public String getRowName(int row) {
        return this.spreadsheet.getRowNames()[row];
    }

    public int getRowIndex(String name) {
        String[] names = this.spreadsheet.getRowNames();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return i;
        }
        throw new OpenLRuntimeException("Row name <" + name + "> not found", (IBoundNode)this.spreadsheet.getBoundNode());
    }

    public int getColumnIndex(String name) {
        String[] names = this.spreadsheet.getColumnNames();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return i;
        }
        throw new OpenLRuntimeException("Column name <" + name + "> not found", (IBoundNode)this.spreadsheet.getBoundNode());
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public IOpenClass getType() {
        return this.spreadsheet.getSpreadsheetType();
    }

    public Object getValue(int row, int column) {
        Object result = this.results[row][column];
        if (result == EMPTY_CELL) {
            return null;
        }
        SpreadsheetCell spreadsheetCell = this.spreadsheet.getCells()[row][column];
        if (result != NEED_TO_CALCULATE_VALUE) {
            Tracer.put((Object)spreadsheetCell, (String)"cell", (Object[])new Object[]{result});
            return result;
        }
        this.results[row][column] = result = Tracer.invoke((Invokable)spreadsheetCell, (Object)this, (Object[])this.params, (IRuntimeEnv)this.env, (Object)this);
        return this.results[row][column];
    }

    public void setValue(int row, int column, Object res) {
        this.results[row][column] = res;
    }

    public final int height() {
        return this.spreadsheet.getHeight();
    }

    public void setFieldValue(String name, Object value) {
        this.targetModule.setFieldValue(name, value);
    }

    public String toString() {
        return "Spreadsheet[" + this.width() + " x " + this.height() + "]";
    }

    public final int width() {
        return this.spreadsheet.getWidth();
    }
}

