/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.meta.DoubleValue;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.StringValue;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetComponentsBuilder;
import org.openl.rules.calc.SpreadsheetContext;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.calc.element.SpreadsheetExpressionMarker;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ConstOpenField;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;

public class SpreadsheetStructureBuilder {
    private static final String EMPTY_ROW_NAME = "$rowName";
    private static final String EMPTY_COLUMN_NAME = "$columnName";
    public static final String DOLLAR_SIGN = "$";
    private static final String COLUMN_FIELD = "$column";
    private static final String ROW_FIELD = "$row";
    private SpreadsheetComponentsBuilder componentsBuilder;
    private IBindingContext spreadsheetBindingContext;
    private IOpenMethodHeader spreadsheetHeader;
    private Boolean autoType;
    private SpreadsheetStructureBuilderHolder spreadsheetStructureBuilderHolder = new SpreadsheetStructureBuilderHolder(this);
    private Map<Integer, IBindingContext> rowContexts = new HashMap<Integer, IBindingContext>();
    private Map<Integer, IBindingContextDelegator> colContexts = new HashMap<Integer, IBindingContextDelegator>();
    private List<SpreadsheetCell> formulaCells = new ArrayList<SpreadsheetCell>();
    private SpreadsheetCell[][] cells;
    private List<SpreadsheetCell> processingCells = new ArrayList<SpreadsheetCell>();
    private List<SpreadsheetCell> extractedCellValues = new ArrayList<SpreadsheetCell>();

    public SpreadsheetStructureBuilderHolder getSpreadsheetStructureBuilderHolder() {
        return this.spreadsheetStructureBuilderHolder;
    }

    public SpreadsheetStructureBuilder(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext, IOpenMethodHeader spreadsheetHeader, Boolean autoType) {
        this.componentsBuilder = new SpreadsheetComponentsBuilder(tableSyntaxNode, bindingContext);
        this.spreadsheetHeader = spreadsheetHeader;
        this.autoType = autoType;
    }

    public void addCellFields(SpreadsheetOpenClass spreadsheetType) {
        this.componentsBuilder.buildHeaders(this.spreadsheetHeader.getType());
        this.buildCellsInternal(spreadsheetType);
    }

    public SpreadsheetCell[][] getCells() {
        this.extractCellValues();
        return (SpreadsheetCell[][])this.cells.clone();
    }

    public IResultBuilder getResultBuilder(Spreadsheet spreadsheet) {
        return this.componentsBuilder.buildResultBuilder(spreadsheet);
    }

    public String[] getRowNames() {
        return this.componentsBuilder.getCellsHeadersExtractor().getRowNames();
    }

    public String[] getColumnNames() {
        return this.componentsBuilder.getCellsHeadersExtractor().getColumnNames();
    }

    private void buildCellsInternal(SpreadsheetOpenClass spreadsheetType) {
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        CellsHeaderExtractor cellsHeadersExtractor = this.componentsBuilder.getCellsHeadersExtractor();
        int rowsCount = cellsHeadersExtractor.getHeight();
        int columnsCount = cellsHeadersExtractor.getWidth();
        this.cells = new SpreadsheetCell[rowsCount][columnsCount];
        this.spreadsheetBindingContext = this.initSpreadsheetBindingContext(spreadsheetType, generalBindingContext);
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                SpreadsheetCell spreadsheetCell;
                this.cells[rowIndex][columnIndex] = spreadsheetCell = this.buildCell(rowIndex, columnIndex);
                this.addSpreadsheetFields(spreadsheetType, spreadsheetCell, rowIndex, columnIndex);
            }
        }
    }

    private IBindingContext initSpreadsheetBindingContext(SpreadsheetOpenClass spreadsheetType, IBindingContext generalBindingContext) {
        return new SpreadsheetContext(generalBindingContext, spreadsheetType);
    }

    private void extractCellValues() {
        CellsHeaderExtractor cellsHeadersExtractor = this.componentsBuilder.getCellsHeadersExtractor();
        int rowsCount = cellsHeadersExtractor.getHeight();
        int columnsCount = cellsHeadersExtractor.getWidth();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            IBindingContext rowBindingContext = this.getRowContext(rowIndex);
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                boolean found = false;
                for (SpreadsheetCell cell : this.extractedCellValues) {
                    int row = cell.getRowIndex();
                    int column = cell.getColumnIndex();
                    if (row != rowIndex || columnIndex != column) continue;
                    found = true;
                }
                if (found) continue;
                this.extractCellValue(rowBindingContext, rowIndex, columnIndex);
            }
        }
    }

    public IOpenClass makeType(SpreadsheetCell cell) {
        if (cell.getType() == null) {
            int rowIndex = cell.getRowIndex();
            int columnIndex = cell.getColumnIndex();
            IBindingContext rowContext = this.getRowContext(rowIndex);
            this.checkAndAddProcessingLoop(cell);
            this.extractCellValue(rowContext, rowIndex, columnIndex);
            this.extractedCellValues.add(cell);
            this.cleanProcessingLoop(cell);
            if (cell.getType() == null) {
                cell.setType((IOpenClass)JavaOpenClass.OBJECT);
            }
        }
        return cell.getType();
    }

    private void cleanProcessingLoop(SpreadsheetCell cell) {
        this.processingCells.remove(cell);
    }

    private void checkAndAddProcessingLoop(SpreadsheetCell cell) {
        if (this.processingCells.contains(cell)) {
            throw new RuntimeException("Spreadsheet Expression Loop:" + this.processingCells.toString());
        }
        this.processingCells.add(cell);
    }

    private void extractCellValue(IBindingContext rowBindingContext, int rowIndex, int columnIndex) {
        Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = this.componentsBuilder.getColumnHeaders();
        Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = this.componentsBuilder.getRowHeaders();
        if (columnHeaders.get(columnIndex) == null || rowHeaders.get(rowIndex) == null) {
            this.cells[rowIndex][columnIndex].setKind(SpreadsheetCellType.EMPTY);
            return;
        }
        ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getColumnNamesTable().getColumn(columnIndex));
        SpreadsheetCell spreadsheetCell = this.cells[rowIndex][columnIndex];
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(cell.getSource(), this.spreadsheetBindingContext);
        String code = StringUtils.trimToNull((String)source.getCode());
        if (SpreadsheetExpressionMarker.isFormula(code)) {
            this.formulaCells.add(spreadsheetCell);
        }
        String name = this.getSpreadsheetCellFieldName(columnHeaders.get(columnIndex).getFirstname(), rowHeaders.get(rowIndex).getFirstname());
        IOpenClass type = spreadsheetCell.getType();
        if (code == null) {
            spreadsheetCell.setValue(null);
        } else if (SpreadsheetExpressionMarker.isFormula(code)) {
            int end = 0;
            if (code.startsWith(SpreadsheetExpressionMarker.OPEN_CURLY_BRACKET.getSymbol())) {
                end = -1;
            }
            SubTextSourceCodeModule srcCode = new SubTextSourceCodeModule((IOpenSourceCodeModule)source, 1, end);
            IMethodSignature signature = this.spreadsheetHeader.getSignature();
            IOpenClass declaringClass = this.spreadsheetHeader.getDeclaringClass();
            OpenMethodHeader header = new OpenMethodHeader(name, type, signature, declaringClass);
            IBindingContext columnBindingContext = this.getColumnContext(columnIndex, rowBindingContext);
            OpenL openl = columnBindingContext.getOpenL();
            try {
                CompositeMethod method;
                if (header.getType() == null) {
                    method = OpenLCellExpressionsCompiler.makeMethodWithUnknownType(openl, (IOpenSourceCodeModule)srcCode, name, signature, declaringClass, columnBindingContext);
                    spreadsheetCell.setType(method.getType());
                } else {
                    method = OpenLCellExpressionsCompiler.makeMethod(openl, (IOpenSourceCodeModule)srcCode, (IOpenMethodHeader)header, columnBindingContext);
                }
                spreadsheetCell.setValue(method);
            }
            catch (CompositeSyntaxNodeException e) {
                this.componentsBuilder.getTableSyntaxNode().addError(e);
                BindHelper.processError((CompositeSyntaxNodeException)e, (IBindingContext)this.spreadsheetBindingContext);
            }
        } else {
            Class instanceClass = type.getInstanceClass();
            if (instanceClass == null) {
                String message = String.format("Type '%s' was loaded with errors", type.getName());
                this.addError(SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source));
            }
            try {
                IBindingContext bindingContext = this.getColumnContext(columnIndex, rowBindingContext);
                Object result = String2DataConvertorFactory.parse(instanceClass, code, bindingContext);
                if (bindingContext.isExecutionMode() && result instanceof IMetaHolder) {
                    ValueMetaInfo meta = new ValueMetaInfo(name, null, (IOpenSourceCodeModule)source);
                    ((IMetaHolder)result).setMetaInfo((IMetaInfo)meta);
                }
                spreadsheetCell.setValue(result);
            }
            catch (Throwable t) {
                String message = String.format("Cannot parse cell value: [%s] to the necessary type", code);
                this.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)t, null, (IOpenSourceCodeModule)source));
            }
        }
    }

    private void addError(SyntaxNodeException e) {
        this.componentsBuilder.getTableSyntaxNode().addError(e);
        BindHelper.processError((SyntaxNodeException)e, (IBindingContext)this.spreadsheetBindingContext);
    }

    private void addSpreadsheetFields(SpreadsheetOpenClass spreadsheetType, SpreadsheetCell spreadsheetCell, int rowIndex, int columnIndex) {
        SpreadsheetHeaderDefinition columnHeaders = this.componentsBuilder.getColumnHeaders().get(columnIndex);
        SpreadsheetHeaderDefinition rowHeaders = this.componentsBuilder.getRowHeaders().get(rowIndex);
        if (columnHeaders == null || rowHeaders == null) {
            return;
        }
        for (SymbolicTypeDefinition columnDefinition : columnHeaders.getVars()) {
            for (SymbolicTypeDefinition rowDefinition : rowHeaders.getVars()) {
                String columnName = columnDefinition.getName().getIdentifier();
                String rowName = rowDefinition.getName().getIdentifier();
                String fieldname = this.getSpreadsheetCellFieldName(columnName, rowName);
                SpreadsheetCellField field = this.createSpreadsheetCellField(this.spreadsheetHeader.getType(), spreadsheetCell, fieldname);
                spreadsheetType.addField((IOpenField)field);
            }
        }
    }

    private String getSpreadsheetCellFieldName(String columnName, String rowName) {
        return (DOLLAR_SIGN + columnName + DOLLAR_SIGN + rowName).intern();
    }

    private SpreadsheetCell buildCell(int rowIndex, int columnIndex) {
        Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = this.componentsBuilder.getColumnHeaders();
        Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = this.componentsBuilder.getRowHeaders();
        ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getColumnNamesTable().getColumn(columnIndex));
        ICell sourceCell = cell.getSource().getCell(0, 0);
        SpreadsheetCell spreadsheetCell = this.spreadsheetBindingContext.isExecutionMode() ? new SpreadsheetCell(rowIndex, columnIndex, null) : new SpreadsheetCell(rowIndex, columnIndex, sourceCell);
        String cellCode = sourceCell.getStringValue();
        IOpenClass cellType = this.deriveCellType(columnHeaders.get(columnIndex), rowHeaders.get(rowIndex), cellCode);
        spreadsheetCell.setType(cellType);
        if (cellCode == null || cellCode.isEmpty()) {
            spreadsheetCell.setKind(SpreadsheetCellType.EMPTY);
        } else if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
            spreadsheetCell.setKind(SpreadsheetCellType.METHOD);
        } else {
            spreadsheetCell.setKind(SpreadsheetCellType.VALUE);
        }
        return spreadsheetCell;
    }

    private IOpenClass deriveCellType(SpreadsheetHeaderDefinition columnHeader, SpreadsheetHeaderDefinition rowHeader, String cellValue) {
        if (columnHeader != null && columnHeader.getType() != null) {
            return columnHeader.getType();
        }
        if (rowHeader != null && rowHeader.getType() != null) {
            return rowHeader.getType();
        }
        try {
            if (SpreadsheetExpressionMarker.isFormula(cellValue)) {
                return this.autoType != false ? null : JavaOpenClass.getOpenClass(DoubleValue.class);
            }
            String2DataConvertorFactory.getConvertor(Double.TYPE).parse(cellValue, null);
            return JavaOpenClass.getOpenClass(DoubleValue.class);
        }
        catch (Throwable t) {
            return JavaOpenClass.getOpenClass(StringValue.class);
        }
    }

    private IBindingContext getRowContext(int rowIndex) {
        IBindingContext rowContext = this.rowContexts.get(rowIndex);
        if (rowContext == null) {
            rowContext = this.makeRowContext(rowIndex);
            this.rowContexts.put(rowIndex, rowContext);
        }
        return rowContext;
    }

    private IBindingContext getColumnContext(int columnIndex, IBindingContext rowBindingContext) {
        IBindingContextDelegator columnContext = this.colContexts.get(columnIndex);
        if (columnContext == null) {
            columnContext = this.makeColumnContext(columnIndex, rowBindingContext);
            this.colContexts.put(columnIndex, columnContext);
        } else {
            columnContext.setDelegate(rowBindingContext);
        }
        return columnContext;
    }

    private IBindingContextDelegator makeColumnContext(int columnIndex, IBindingContext rowBindingContext) {
        String columnOpenClassName = String.format("%sColType%d", this.spreadsheetHeader.getName(), columnIndex);
        ComponentOpenClass columnOpenClass = this.createAndPopulateColumnOpenClass(columnIndex, columnOpenClassName);
        return new SpreadsheetContext(rowBindingContext, columnOpenClass);
    }

    private ComponentOpenClass createRowOrColumnOpenClass(String openClassName, OpenL openl) {
        return new ComponentOpenClass(openClassName, openl);
    }

    private IBindingContextDelegator makeRowContext(int rowIndex) {
        String rowOpenClassName = String.format("%sRowType%d", this.spreadsheetHeader.getName(), rowIndex);
        ComponentOpenClass rowOpenClass = this.createAndPopulateRowOpenClass(rowIndex, rowOpenClassName);
        return new SpreadsheetContext(this.spreadsheetBindingContext, rowOpenClass);
    }

    private ComponentOpenClass createAndPopulateColumnOpenClass(int columnIndex, String columnOpenClassName) {
        String columnName;
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        ComponentOpenClass columnOpenClass = this.createRowOrColumnOpenClass(columnOpenClassName, generalBindingContext.getOpenL());
        int height = this.cells.length;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            SpreadsheetHeaderDefinition headerDefinition = this.componentsBuilder.getRowHeaders().get(rowIndex);
            if (headerDefinition == null) continue;
            SpreadsheetCell cell = this.cells[rowIndex][columnIndex];
            for (SymbolicTypeDefinition typeDefinition : headerDefinition.getVars()) {
                String fieldName = (DOLLAR_SIGN + typeDefinition.getName().getIdentifier()).intern();
                SpreadsheetCellField field = this.createSpreadsheetCellField((IOpenClass)columnOpenClass, cell, fieldName);
                columnOpenClass.addField((IOpenField)field);
            }
        }
        String nameOpenField = COLUMN_FIELD;
        ConstOpenField columnField = new ConstOpenField(nameOpenField, (Object)columnIndex, (IOpenClass)JavaOpenClass.INT);
        columnOpenClass.addField((IOpenField)columnField);
        SpreadsheetHeaderDefinition shd = this.componentsBuilder.getRowHeaders().get(columnIndex);
        if (shd != null && (columnName = shd.getFirstname()) != null) {
            ConstOpenField columnNameField = new ConstOpenField(EMPTY_COLUMN_NAME, (Object)columnName, (IOpenClass)JavaOpenClass.STRING);
            columnOpenClass.addField((IOpenField)columnNameField);
        }
        return columnOpenClass;
    }

    private ComponentOpenClass createAndPopulateRowOpenClass(int rowIndex, String rowOpenClassName) {
        String rowName;
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        ComponentOpenClass rowOpenClass = this.createRowOrColumnOpenClass(rowOpenClassName, generalBindingContext.getOpenL());
        int width = this.cells[0].length;
        for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
            SpreadsheetHeaderDefinition columnHeader = this.componentsBuilder.getColumnHeaders().get(columnIndex);
            if (columnHeader == null) continue;
            SpreadsheetCell cell = this.cells[rowIndex][columnIndex];
            for (SymbolicTypeDefinition typeDefinition : columnHeader.getVars()) {
                String fieldName = (DOLLAR_SIGN + typeDefinition.getName().getIdentifier()).intern();
                SpreadsheetCellField field = this.createSpreadsheetCellField((IOpenClass)rowOpenClass, cell, fieldName);
                rowOpenClass.addField((IOpenField)field);
            }
        }
        String nameOpenField = ROW_FIELD;
        ConstOpenField rowField = new ConstOpenField(nameOpenField, (Object)rowIndex, (IOpenClass)JavaOpenClass.INT);
        rowOpenClass.addField((IOpenField)rowField);
        SpreadsheetHeaderDefinition shd = this.componentsBuilder.getRowHeaders().get(rowIndex);
        if (shd != null && (rowName = shd.getFirstname()) != null) {
            ConstOpenField rowNameField = new ConstOpenField(EMPTY_ROW_NAME, (Object)rowName, (IOpenClass)JavaOpenClass.STRING);
            rowOpenClass.addField((IOpenField)rowNameField);
        }
        return rowOpenClass;
    }

    private SpreadsheetCellField createSpreadsheetCellField(IOpenClass rowOpenClass, SpreadsheetCell cell, String fieldName) {
        return SpreadsheetCellField.createSpreadsheetCellField(this.getSpreadsheetStructureBuilderHolder(), rowOpenClass, fieldName, cell);
    }
}

