/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result.convertor;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.result.SpreadsheetResultHelper;
import org.openl.rules.calc.result.convertor.CalculationStep;
import org.openl.rules.calc.result.convertor.CodeStep;
import org.openl.rules.calc.result.convertor.ColumnToExtract;
import org.openl.rules.calc.result.convertor.CompoundStep;
import org.openl.rules.calc.result.convertor.NestedDataRowExtractorsFactory;
import org.openl.rules.calc.result.convertor.NestedSpreadsheetConfiguration;
import org.openl.rules.calc.result.convertor.RowExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NestedSpreadsheetResultConverter<Simple extends CodeStep, Compound extends CompoundStep> {
    private final Logger log = LoggerFactory.getLogger(NestedSpreadsheetResultConverter.class);
    private NestedDataRowExtractorsFactory<Simple, Compound> rowExtractorsFactory;
    private NestedSpreadsheetConfiguration<Simple, Compound> conf;
    private int currentNestingLevel;

    public NestedSpreadsheetResultConverter(int currentNestingLevel, NestedSpreadsheetConfiguration<Simple, Compound> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be empty");
        }
        this.conf = configuration;
        this.currentNestingLevel = currentNestingLevel;
        this.rowExtractorsFactory = configuration.getRowExtractorsFactory(currentNestingLevel);
    }

    public List<CodeStep> process(SpreadsheetResult spreadsheetResult) {
        ArrayList<CodeStep> steps = new ArrayList<CodeStep>();
        if (spreadsheetResult != null) {
            int height = spreadsheetResult.getHeight();
            for (int row = 0; row < height; ++row) {
                CodeStep step = this.processRow(spreadsheetResult, row);
                steps.add(step);
            }
            return steps;
        }
        this.log.warn("Spreadsheet result is null");
        return steps;
    }

    private CodeStep processRow(SpreadsheetResult spreadsheetResult, int row) {
        CalculationStep step = null;
        RowExtractor<?> rowExtractor = this.rowExtractorsFactory.getRowExtractor(this.anyNestedValueInRow(spreadsheetResult, row));
        step = (CalculationStep)rowExtractor.extract(spreadsheetResult, row);
        step.setStepName(spreadsheetResult.getRowName(row));
        return step;
    }

    private boolean anyNestedValueInRow(SpreadsheetResult spreadsheetResult, int row) {
        List<ColumnToExtract> compoundColumns = this.conf.getCompoundColumnsToExtract(this.currentNestingLevel);
        for (ColumnToExtract column : compoundColumns) {
            int columnIndex = SpreadsheetResultHelper.getColumnIndexByName(column.getColumnName(), spreadsheetResult.getColumnNames());
            Object valueInColumn = spreadsheetResult.getValue(row, columnIndex);
            if (!this.containsNested(valueInColumn)) continue;
            return true;
        }
        return false;
    }

    private boolean containsNested(Object value) {
        return value instanceof SpreadsheetResult || value instanceof SpreadsheetResult[];
    }
}

