/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result.convertor;

import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.openl.rules.calc.result.convertor.CalculationStep;
import org.openl.rules.calc.result.convertor.ColumnToExtract;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.ObjectToDataConvertorFactory;
import org.openl.util.StringTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpreadsheetColumnExtractor<S extends CalculationStep> {
    private final Logger log = LoggerFactory.getLogger(SpreadsheetColumnExtractor.class);
    private ColumnToExtract column;
    private boolean mandatory;

    public SpreadsheetColumnExtractor(ColumnToExtract column, boolean mandatory) {
        this.column = column;
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public ColumnToExtract getColumn() {
        return this.column;
    }

    public void setColumn(ColumnToExtract column) {
        this.column = column;
    }

    public void convertAndStoreData(Object valueForStoraging, S spreadsheetRow) {
        if (valueForStoraging != null) {
            Object value = this.convert(valueForStoraging);
            this.store(value, spreadsheetRow);
        }
    }

    private void store(Object value, S step) {
        Method setterMethod = this.getSetterMethod(step);
        if (setterMethod != null) {
            try {
                setterMethod.invoke(step, value);
            }
            catch (Exception e) {
                this.log.warn(e.getMessage(), (Throwable)e);
            }
        } else {
            this.log.warn("Cannot find setter in {} class for [{}] column", (Object)step.getClass().getName(), (Object)this.column.getColumnName());
        }
    }

    private Method getSetterMethod(S step) {
        Method setterMethod = null;
        String setterName = StringTool.getSetterName((String)this.column.getColumnName());
        try {
            setterMethod = step.getClass().getMethod(setterName, this.column.getExpectedType());
        }
        catch (Exception e) {
            try {
                setterName = this.getSetterName(this.column.getColumnName());
                setterMethod = step.getClass().getMethod(setterName, this.column.getExpectedType());
            }
            catch (Exception e1) {
                this.log.warn(e1.getMessage(), (Throwable)e1);
            }
        }
        return setterMethod;
    }

    protected String getSetterName(String fieldName) {
        return String.format("set%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1).toLowerCase());
    }

    private Object convert(Object x) {
        if (this.needConversion(x)) {
            IObjectToDataConvertor convertor = ObjectToDataConvertorFactory.getConvertor(this.column.getExpectedType(), x.getClass());
            try {
                return convertor.convert(x, null);
            }
            catch (Exception e) {
                this.log.warn("Cannot convert value {} to {}", new Object[]{x, this.column.getExpectedType().getName(), e});
            }
        }
        return x;
    }

    private boolean needConversion(Object x) {
        return !ClassUtils.isAssignable(x.getClass(), this.column.getExpectedType());
    }
}

