/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result.gen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.result.gen.DecoratorMethodWriter;
import org.openl.rules.calc.result.gen.DefaultConstructorWriter;
import org.openl.rules.calc.result.gen.SettersWriter;
import org.openl.rules.datatype.gen.BeanByteCodeGenerator;
import org.openl.rules.datatype.gen.DefaultFieldDescription;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.ClassDescriptionWriter;
import org.openl.rules.datatype.gen.bean.writers.ConstructorWithParametersWriter;
import org.openl.rules.table.Point;

public class CustomSpreadsheetResultByteCodeGenerator
extends BeanByteCodeGenerator {
    private final Class<?> superClass = SpreadsheetResult.class;
    private static final Map<String, FieldDescription> spreadsheetResultFields = new LinkedHashMap<String, FieldDescription>();
    private Map<String, FieldDescription> cellFieldsDescription;
    private Map<String, Point> fieldCoordinates;

    public CustomSpreadsheetResultByteCodeGenerator(String canonicalBeanName, Map<String, FieldDescription> cellFieldsDescription) {
        this(canonicalBeanName, cellFieldsDescription, null);
    }

    public CustomSpreadsheetResultByteCodeGenerator(String canonicalBeanName, Map<String, FieldDescription> cellFieldsDescription, Map<String, Point> fieldCoordinates) {
        super(canonicalBeanName);
        this.cellFieldsDescription = new HashMap<String, FieldDescription>(cellFieldsDescription);
        boolean generateSetters = false;
        if (fieldCoordinates != null && !fieldCoordinates.isEmpty()) {
            this.fieldCoordinates = new HashMap<String, Point>(fieldCoordinates);
            generateSetters = true;
        }
        this.initWriters(generateSetters);
    }

    private void initWriters(boolean generateSetters) {
        this.addWriter(new ClassDescriptionWriter(this.getBeanNameWithPackage(), this.superClass));
        this.addWriter(new ConstructorWithParametersWriter(this.getBeanNameWithPackage(), this.superClass, new HashMap<String, FieldDescription>(), spreadsheetResultFields, spreadsheetResultFields));
        this.addWriter(new DecoratorMethodWriter(this.getBeanNameWithPackage(), this.cellFieldsDescription, "getFieldValue", "get"));
        if (generateSetters) {
            this.addWriter(new DefaultConstructorWriter(this.getBeanNameWithPackage(), this.superClass, this.getMaxPoint()));
            this.addWriter(new SettersWriter(this.getBeanNameWithPackage(), this.cellFieldsDescription, this.fieldCoordinates));
        }
    }

    private Point getMaxPoint() {
        int[] colMas = this.getColumns();
        Arrays.sort(colMas);
        int maxColumn = colMas[colMas.length - 1];
        int[] rowMas = this.getRows();
        Arrays.sort(rowMas);
        int maxRow = rowMas[rowMas.length - 1];
        return new Point(maxColumn, maxRow);
    }

    private int[] getRows() {
        int[] mas = new int[this.fieldCoordinates.size()];
        int i = 0;
        for (Point point : this.fieldCoordinates.values()) {
            mas[i] = point.getRow();
            ++i;
        }
        return mas;
    }

    private int[] getColumns() {
        int[] mas = new int[this.fieldCoordinates.size()];
        int i = 0;
        for (Point point : this.fieldCoordinates.values()) {
            mas[i] = point.getColumn();
            ++i;
        }
        return mas;
    }

    static {
        spreadsheetResultFields.put("results", new DefaultFieldDescription(Object[][].class));
        spreadsheetResultFields.put("rowNames", new DefaultFieldDescription(String[].class));
        spreadsheetResultFields.put("columnNames", new DefaultFieldDescription(String[].class));
        spreadsheetResultFields.put("fieldsCoordinates", new DefaultFieldDescription(Map.class));
    }
}

