/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result.gen;

import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.asm.invoker.SpreadsheetResultInvoker;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.GettersWriter;
import org.openl.util.NumberUtils;
import org.openl.util.generation.JavaClassGeneratorHelper;

public class DecoratorMethodWriter
extends GettersWriter {
    private String nameOfTheMethodToCall;
    private String prefixForDecorator;

    public DecoratorMethodWriter(String beanNameWithPackage, Map<String, FieldDescription> fieldsForDecorating, String nameOfTheMethodToCall, String prefixForDecorator) {
        super(beanNameWithPackage, fieldsForDecorating);
        this.nameOfTheMethodToCall = nameOfTheMethodToCall;
        this.prefixForDecorator = prefixForDecorator;
    }

    @Override
    protected void generateGetter(ClassWriter classWriter, Map.Entry<String, FieldDescription> fieldEntry) {
        String fieldName = fieldEntry.getKey();
        FieldDescription field = fieldEntry.getValue();
        String methodName = String.format("%s%s", this.prefixForDecorator, fieldName);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, methodName, String.format("()%s", ByteCodeGeneratorHelper.getJavaType(field)), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)fieldName);
        SpreadsheetResultInvoker.getMethod(this.nameOfTheMethodToCall).invoke(methodVisitor);
        String typeNameForCast = null;
        typeNameForCast = DecoratorMethodWriter.getTypeNameForCast(field);
        methodVisitor.visitTypeInsn(192, typeNameForCast);
        if (field.getType().isPrimitive()) {
            String nameOftheWrapperMethod = String.format("%sValue", field.getCanonicalTypeName());
            methodVisitor.visitMethodInsn(182, Type.getInternalName((Class)NumberUtils.getWrapperType((String)field.getCanonicalTypeName())), nameOftheWrapperMethod, String.format("()%s", ByteCodeGeneratorHelper.getJavaType(field)));
        }
        methodVisitor.visitInsn(ByteCodeGeneratorHelper.getConstantForReturn(field.getType()));
        methodVisitor.visitMaxs(2, 1);
        methodVisitor.visitEnd();
    }

    public static String getTypeNameForCast(FieldDescription fieldType) {
        String fieldCanonicalTypeName = fieldType.getCanonicalTypeName();
        if (fieldType.getType().isPrimitive()) {
            Class wrapperType = NumberUtils.getWrapperType((String)fieldCanonicalTypeName);
            fieldCanonicalTypeName = wrapperType.getCanonicalName();
        }
        String typeName = JavaClassGeneratorHelper.isArray((String)fieldCanonicalTypeName) ? JavaClassGeneratorHelper.getJavaType((String)fieldCanonicalTypeName) : JavaClassGeneratorHelper.replaceDots((String)fieldCanonicalTypeName);
        return typeName;
    }
}

