/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openl.binding.IBindingContext;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.StringValue;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;
import org.openl.rules.helpers.IntRange;
import org.openl.util.RuntimeExceptionWrapper;

public class ObjectToDataConvertorFactory {
    private static Map<ClassCastPair, IObjectToDataConvertor> convertors = new HashMap<ClassCastPair, IObjectToDataConvertor>();
    public static final IObjectToDataConvertor NO_Convertor;

    public static synchronized IObjectToDataConvertor getConvertor(Class<?> toClass, Class<?> fromClass) {
        if (toClass == fromClass) {
            return CopyConvertor.the;
        }
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        IObjectToDataConvertor convertor = NO_Convertor;
        if (!convertors.containsKey(pair)) {
            Constructor ctr;
            Method method = MethodUtils.getAccessibleMethod(toClass, (String)"valueOf", (Class[])new Class[]{fromClass});
            convertor = method != null ? new StaticMethodConvertor(method) : ((ctr = ConstructorUtils.getMatchingAccessibleConstructor(toClass, (Class[])new Class[]{fromClass})) != null ? new MatchedConstructorConvertor(ctr) : NO_Convertor);
            convertors.put(pair, convertor);
        } else {
            convertor = convertors.get(pair);
        }
        return convertor;
    }

    public static IObjectToDataConvertor registerConvertor(Class<?> toClass, Class<?> fromClass, IObjectToDataConvertor convertor) {
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        return convertors.put(pair, convertor);
    }

    static {
        try {
            convertors.put(new ClassCastPair(Integer.class, IntRange.class), new IObjectToDataConvertor(){

                @Override
                public Object convert(Object data, IBindingContext bindingContext) {
                    return new IntRange((Integer)data);
                }
            });
            convertors.put(new ClassCastPair(Integer.TYPE, IntRange.class), new IObjectToDataConvertor(){

                @Override
                public Object convert(Object data, IBindingContext bindingContext) {
                    return new IntRange((Integer)data);
                }
            });
            convertors.put(new ClassCastPair(Double.class, DoubleValue.class), new IObjectToDataConvertor(){

                @Override
                public Object convert(Object data, IBindingContext bindingContext) {
                    return new DoubleValue(((Double)data).doubleValue());
                }
            });
            convertors.put(new ClassCastPair(Double.class, Double.TYPE), CopyConvertor.the);
            convertors.put(new ClassCastPair(Double.TYPE, Double.class), CopyConvertor.the);
            convertors.put(new ClassCastPair(Integer.TYPE, Integer.class), CopyConvertor.the);
            convertors.put(new ClassCastPair(Integer.class, Integer.TYPE), CopyConvertor.the);
            convertors.put(new ClassCastPair(Double.TYPE, DoubleValue.class), new IObjectToDataConvertor(){

                @Override
                public Object convert(Object data, IBindingContext bindingContext) {
                    return new DoubleValue(((Double)data).doubleValue());
                }
            });
            convertors.put(new ClassCastPair(Date.class, Calendar.class), new IObjectToDataConvertor(){

                @Override
                public Object convert(Object data, IBindingContext bindingContext) {
                    Calendar cal = Calendar.getInstance(LocaleDependConvertor.getLocale());
                    cal.setTime((Date)data);
                    return cal;
                }
            });
            convertors.put(new ClassCastPair(Date.class, Calendar.class), new IObjectToDataConvertor(){

                @Override
                public Object convert(Object data, IBindingContext bindingContext) {
                    Calendar cal = Calendar.getInstance(LocaleDependConvertor.getLocale());
                    cal.setTime((Date)data);
                    return cal;
                }
            });
            convertors.put(new ClassCastPair(ByteValue.class, Byte.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(ShortValue.class, Short.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(IntValue.class, Integer.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(LongValue.class, Long.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(FloatValue.class, Float.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(DoubleValue.class, Double.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(BigIntegerValue.class, BigInteger.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(BigDecimalValue.class, BigDecimal.class), new GetValueConvertor());
            convertors.put(new ClassCastPair(StringValue.class, String.class), new GetValueConvertor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NO_Convertor = new IObjectToDataConvertor(){

            @Override
            public Object convert(Object data, IBindingContext bindingContext) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class GetValueConvertor
    implements IObjectToDataConvertor {
        @Override
        public Object convert(Object data, IBindingContext bindingContext) {
            if (data != null) {
                Method getValueMethod = null;
                try {
                    getValueMethod = data.getClass().getMethod("getValue", new Class[0]);
                }
                catch (Exception e) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)e);
                }
                Object value = null;
                try {
                    value = getValueMethod.invoke(data, new Object[0]);
                }
                catch (Exception e) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)e);
                }
                return value;
            }
            return data;
        }
    }

    public static class CopyConvertor
    implements IObjectToDataConvertor {
        public static CopyConvertor the = new CopyConvertor();

        @Override
        public Object convert(Object data, IBindingContext bindingContext) {
            return data;
        }
    }

    public static class StaticMethodConvertor
    implements IObjectToDataConvertor {
        private Method staticMethod;

        public StaticMethodConvertor(Method staticMethod) {
            if (!Modifier.isStatic(staticMethod.getModifiers())) {
                throw new IllegalArgumentException("Income method should be static");
            }
            this.staticMethod = staticMethod;
        }

        @Override
        public Object convert(Object data, IBindingContext bindingContext) {
            try {
                return this.staticMethod.invoke(null, data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static class MatchedConstructorConvertor
    implements IObjectToDataConvertor {
        private Constructor<?> ctr;

        public MatchedConstructorConvertor(Constructor<?> ctr) {
            this.ctr = ctr;
        }

        @Override
        public Object convert(Object data, IBindingContext bindingContext) {
            try {
                return this.ctr.newInstance(data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static class ClassCastPair {
        private Class<?> from;
        private Class<?> to;

        public ClassCastPair(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }

        public int hashCode() {
            return this.to.hashCode() + this.from.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassCastPair)) {
                return false;
            }
            ClassCastPair pair = (ClassCastPair)obj;
            return this.from == pair.from && this.to == pair.to;
        }
    }
}

