/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.openl.binding.IBindingContext;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.meta.DoubleValue;
import org.openl.rules.convertor.IString2DataConverterWithContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2ArrayConvertor;
import org.openl.rules.convertor.String2BigDecimalConvertor;
import org.openl.rules.convertor.String2BigIntegerConvertor;
import org.openl.rules.convertor.String2BooleanConvertor;
import org.openl.rules.convertor.String2ByteConvertor;
import org.openl.rules.convertor.String2CalendarConvertor;
import org.openl.rules.convertor.String2CharConvertor;
import org.openl.rules.convertor.String2ClassConvertor;
import org.openl.rules.convertor.String2ConstructorConvertor;
import org.openl.rules.convertor.String2DateConvertor;
import org.openl.rules.convertor.String2DoubleConvertor;
import org.openl.rules.convertor.String2DoubleRangeConvertor;
import org.openl.rules.convertor.String2DoubleValueConvertor;
import org.openl.rules.convertor.String2EnumConvertor;
import org.openl.rules.convertor.String2FloatConvertor;
import org.openl.rules.convertor.String2IntConvertor;
import org.openl.rules.convertor.String2IntRangeConvertor;
import org.openl.rules.convertor.String2LongConvertor;
import org.openl.rules.convertor.String2OpenClassConvertor;
import org.openl.rules.convertor.String2ShortConvertor;
import org.openl.rules.convertor.String2StringConvertor;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.types.IOpenClass;

public class String2DataConvertorFactory {
    private static HashMap<Class<?>, IString2DataConvertor<?>> convertors;
    private static Map<Class<?>, IString2DataConvertor> convertorsCache;

    public static synchronized <T> T parse(Class<T> clazz, String data, IBindingContext bindingContext) {
        IString2DataConvertor<T> convertor = String2DataConvertorFactory.getConvertor(clazz);
        if (convertor instanceof IString2DataConverterWithContext) {
            IString2DataConverterWithContext convertorCxt = (IString2DataConverterWithContext)((Object)convertor);
            return convertorCxt.parse(data, null, bindingContext);
        }
        return convertor.parse(data, null);
    }

    public static synchronized <T> IString2DataConvertor<T> getConvertor(Class<T> clazz) {
        IString2DataConvertor<Object> convertor = convertorsCache.get(clazz);
        if (convertor != null) {
            return convertor;
        }
        if (clazz.isEnum()) {
            convertor = new String2EnumConvertor<T>(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            convertor = new String2ArrayConvertor(componentType);
        } else {
            convertor = new String2ConstructorConvertor<T>(clazz);
        }
        convertorsCache.put(clazz, convertor);
        return convertor;
    }

    private static void unregisterConvertorForClass(Class<?> clazz) {
        convertorsCache.remove(clazz);
    }

    public static synchronized void unregisterClassLoader(ClassLoader classLoader) {
        ArrayList toRemove = new ArrayList();
        for (Class<Object> clazz : convertorsCache.keySet()) {
            if (convertors.containsKey(clazz)) continue;
            ClassLoader cl = clazz.getClassLoader();
            if (cl == classLoader) {
                toRemove.add(clazz);
            }
            if (!(classLoader instanceof OpenLBundleClassLoader) || !((OpenLBundleClassLoader)classLoader).containsClassLoader(cl)) continue;
            toRemove.add(clazz);
        }
        for (Class<Object> clazz : toRemove) {
            String2DataConvertorFactory.unregisterConvertorForClass(clazz);
        }
    }

    static {
        convertorsCache = new WeakHashMap();
        convertors = new HashMap();
        convertors.put(Object.class, new String2StringConvertor());
        convertors.put(Integer.TYPE, new String2IntConvertor());
        convertors.put(Double.TYPE, new String2DoubleConvertor());
        convertors.put(Character.TYPE, new String2CharConvertor());
        convertors.put(Boolean.TYPE, new String2BooleanConvertor());
        convertors.put(Long.TYPE, new String2LongConvertor());
        convertors.put(Byte.TYPE, new String2ByteConvertor());
        convertors.put(Short.TYPE, new String2ShortConvertor());
        convertors.put(Float.TYPE, new String2FloatConvertor());
        convertors.put(Integer.class, new String2IntConvertor());
        convertors.put(Byte.class, new String2ByteConvertor());
        convertors.put(Short.class, new String2ShortConvertor());
        convertors.put(Float.class, new String2FloatConvertor());
        convertors.put(Double.class, new String2DoubleConvertor());
        convertors.put(Character.class, new String2CharConvertor());
        convertors.put(Boolean.class, new String2BooleanConvertor());
        convertors.put(Long.class, new String2LongConvertor());
        convertors.put(String.class, new String2StringConvertor());
        convertors.put(Date.class, new String2DateConvertor());
        convertors.put(Calendar.class, new String2CalendarConvertor());
        convertors.put(Class.class, new String2ClassConvertor());
        convertors.put(IOpenClass.class, new String2OpenClassConvertor());
        convertors.put(DoubleValue.class, new String2DoubleValueConvertor());
        convertors.put(IntRange.class, new String2IntRangeConvertor());
        convertors.put(DoubleRange.class, new String2DoubleRangeConvertor());
        convertors.put(BigInteger.class, new String2BigIntegerConvertor());
        convertors.put(BigDecimal.class, new String2BigDecimalConvertor());
        convertorsCache.putAll(convertors);
    }
}

