/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import org.openl.OpenL;
import org.openl.meta.StringValue;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.ITable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class ColumnDescriptor {
    private IOpenField field;
    private StringValue displayValue;
    private OpenL openl;
    private boolean valuesAnArray = false;
    private boolean constructor = false;
    private Map<String, Integer> uniqueIndex = null;
    private Map<String, Integer> formattedUniqueIndex = null;
    private IdentifierNode[] fieldChainTokens;

    public ColumnDescriptor(IOpenField field, StringValue displayValue, OpenL openl, boolean constructor, IdentifierNode[] fieldChainTokens) {
        this.field = field;
        this.displayValue = displayValue;
        this.openl = openl;
        this.constructor = constructor;
        this.fieldChainTokens = fieldChainTokens;
        if (field != null) {
            this.valuesAnArray = ColumnDescriptor.isValuesAnArray(field.getType());
        }
    }

    protected IRuntimeEnv getRuntimeEnv() {
        return this.openl.getVm().getRuntimeEnv();
    }

    protected static boolean isValuesAnArray(IOpenClass paramType) {
        return paramType.getAggregateInfo().isAggregate(paramType);
    }

    protected IOpenField getField() {
        return this.field;
    }

    public Object getColumnValue(Object target) {
        return this.field == null ? target : this.field.get(target, this.getRuntimeEnv());
    }

    public String getDisplayName() {
        return this.displayValue.getValue();
    }

    public Object getLiteral(IOpenClass paramType, ILogicalTable valuesTable, OpenlToolAdaptor ota) throws SyntaxNodeException {
        Object resultLiteral = null;
        boolean valuesAnArray = ColumnDescriptor.isValuesAnArray(paramType);
        if (valuesAnArray) {
            paramType = paramType.getAggregateInfo().getComponentType(paramType);
        }
        valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
        if (!valuesAnArray) {
            resultLiteral = RuleRowHelper.loadSingleParam(paramType, this.field == null ? "constructor" : this.field.getName(), null, valuesTable, ota);
        }
        return resultLiteral;
    }

    public String getName() {
        return this.field == null ? "this" : this.field.getName();
    }

    public IOpenClass getType() {
        return this.field.getType();
    }

    public synchronized Map<String, Integer> getUniqueIndex(ITable table, int idx) throws SyntaxNodeException {
        if (this.uniqueIndex == null) {
            this.uniqueIndex = table.makeUniqueIndex(idx);
        }
        return this.uniqueIndex;
    }

    public synchronized Map<String, Integer> getFormattedUniqueIndex(ITable table, int idx) throws SyntaxNodeException {
        if (this.formattedUniqueIndex == null) {
            this.formattedUniqueIndex = table.makeFormattedUniqueIndex(idx);
        }
        return this.formattedUniqueIndex;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public IdentifierNode[] getFieldChainTokens() {
        return this.fieldChainTokens;
    }

    public void populateLiteral(Object literal, ILogicalTable valuesTable, OpenlToolAdaptor toolAdapter) throws SyntaxNodeException {
        if (this.field != null) {
            IOpenClass paramType = this.field.getType();
            if (this.valuesAnArray) {
                paramType = paramType.getAggregateInfo().getComponentType(paramType);
            }
            valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
            if (!this.valuesAnArray) {
                Object res = RuleRowHelper.loadSingleParam(paramType, this.field.getName(), null, valuesTable, toolAdapter);
                if (res != null) {
                    this.field.set(literal, res, this.getRuntimeEnv());
                }
            } else {
                Object arrayValues = this.getArrayValues(valuesTable, toolAdapter, paramType);
                this.field.set(literal, arrayValues, this.getRuntimeEnv());
            }
        }
    }

    public boolean isReference() {
        return false;
    }

    private Object getArrayValues(ILogicalTable valuesTable, OpenlToolAdaptor ota, IOpenClass paramType) throws SyntaxNodeException {
        if (valuesTable.getHeight() == 1 && valuesTable.getWidth() == 1) {
            return RuleRowHelper.loadCommaSeparatedParam(paramType, this.field.getName(), null, (ILogicalTable)valuesTable.getRow(0), ota);
        }
        if (valuesTable.getHeight() != 1) {
            valuesTable.transpose();
        }
        return this.loadMultiRowArray(valuesTable, ota, paramType);
    }

    private Object loadMultiRowArray(ILogicalTable logicalTable, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) throws SyntaxNodeException {
        int valuesTableHeight = RuleRowHelper.calculateHeight(logicalTable);
        ArrayList<Object> values = new ArrayList<Object>(valuesTableHeight);
        for (int i = 0; i < valuesTableHeight; ++i) {
            Object res = RuleRowHelper.loadSingleParam(paramType, this.field.getName(), null, (ILogicalTable)logicalTable.getRow(i), openlAdaptor);
            if (res == null) {
                res = paramType.nullObject();
            }
            values.add(res);
        }
        Object arrayValues = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{values.size()});
        for (int i = 0; i < values.size(); ++i) {
            Array.set(arrayValues, i, values.get(i));
        }
        return arrayValues;
    }
}

