/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.StringValue;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultField;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.ITable;
import org.openl.rules.data.PrimaryKeyField;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.AOpenField;
import org.openl.types.impl.DatatypeArrayElementField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.text.ILocation;

public class DataTableBindHelper {
    private static final char INDEX_ROW_REFERENCE_START_SYMBOL = '>';
    private static final String FPK = "_PK_";
    protected static final String CONSTRUCTOR_FIELD = "this";
    private static final String CODE_DELIMETERS = ". \n\r";
    private static final String INDEX_ROW_REFERENCE_DELIMITER = " >\n\r";
    private static final String LINK_DELIMETERS = ".";
    public static final String ARRAY_ACCESS_PATTERN = ".+\\[[0-9]+\\]$";
    public static final String PRECISION_PATTERN = "^\\(\\-?[0-9]+\\)$";
    public static final String SPREADSHEETRESULTFIELD_PATTERN = "^\\$.+\\$.+$";

    public static boolean hasForeignKeysRow(ILogicalTable dataTable) {
        ILogicalTable potentialForeignKeysRow = (ILogicalTable)dataTable.getRows(1, 1);
        int columnsCount = potentialForeignKeysRow.getWidth();
        for (int i = 0; i < columnsCount; ++i) {
            ILogicalTable cell = (ILogicalTable)potentialForeignKeysRow.getColumn(i);
            String value = cell.getSource().getCell(0, 0).getStringValue();
            if (value == null || value.trim().length() == 0) continue;
            return value.charAt(0) == '>';
        }
        return false;
    }

    public static ILogicalTable getTableBody(TableSyntaxNode tsn) {
        int startRow = 0;
        startRow = !tsn.hasPropertiesDefinedInTable() ? 1 : 2;
        return (ILogicalTable)tsn.getTable().getRows(startRow);
    }

    public static boolean isHorizontalTable(ILogicalTable dataTableBody, IOpenClass tableType) {
        if (dataTableBody.getHeight() != 1) {
            int fieldsCount2;
            int fieldsCount1 = DataTableBindHelper.countChangeableFields(dataTableBody, tableType);
            return fieldsCount1 >= (fieldsCount2 = DataTableBindHelper.countChangeableFields((ILogicalTable)dataTableBody.transpose(), tableType));
        }
        return false;
    }

    private static int countChangeableFields(ILogicalTable dataTable, IOpenClass tableType) {
        int count = 0;
        int width = dataTable.getWidth();
        for (int i = 0; i < width; ++i) {
            IOpenField field;
            String fieldName = ((ILogicalTable)dataTable.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (fieldName == null) continue;
            if ((fieldName = StringUtils.trim((String)fieldName)).indexOf(LINK_DELIMETERS) > 0) {
                fieldName = fieldName.substring(0, fieldName.indexOf(LINK_DELIMETERS));
            }
            if (fieldName.indexOf("[") > 0) {
                fieldName = fieldName.substring(0, fieldName.indexOf("["));
            }
            if ((field = DataTableBindHelper.findField(fieldName, null, tableType)) == null || field.isConst() || !field.isWritable()) continue;
            ++count;
        }
        return count;
    }

    public static IOpenField findField(String fieldName, ITable table, IOpenClass tableType) {
        if (FPK.equals(fieldName)) {
            return new PrimaryKeyField(FPK, table);
        }
        return tableType.getField(fieldName, true);
    }

    public static ILogicalTable getHorizontalTable(ILogicalTable tableBody, IOpenClass tableType) {
        ILogicalTable resultTable = null;
        if (tableBody != null) {
            resultTable = DataTableBindHelper.isHorizontalTable(tableBody, tableType) ? tableBody : (ILogicalTable)tableBody.transpose();
        }
        return resultTable;
    }

    public static ILogicalTable getHorizontalDataWithTitle(ILogicalTable horizDataTableBody) {
        int startIndex = DataTableBindHelper.getStartIndexForDataWithTitlesSection(horizDataTableBody);
        return (ILogicalTable)horizDataTableBody.getRows(startIndex);
    }

    public static ILogicalTable getSubTableForBusinessView(ILogicalTable tableBody, IOpenClass tableType) {
        if (DataTableBindHelper.isHorizontalTable(tableBody, tableType)) {
            return DataTableBindHelper.getHorizontalDataWithTitle(tableBody);
        }
        return DataTableBindHelper.getVerticalDataWithTitle(tableBody);
    }

    private static ILogicalTable getVerticalDataWithTitle(ILogicalTable verticalTableBody) {
        ILogicalTable horizDataTableBody = (ILogicalTable)verticalTableBody.transpose();
        int startIndex = DataTableBindHelper.getStartIndexForDataWithTitlesSection(horizDataTableBody);
        return (ILogicalTable)verticalTableBody.getColumns(startIndex);
    }

    private static int getStartIndexForDataWithTitlesSection(ILogicalTable horizDataTableBody) {
        boolean hasForeignKeysRow = DataTableBindHelper.hasForeignKeysRow(horizDataTableBody);
        if (hasForeignKeysRow) {
            return 2;
        }
        return 1;
    }

    public static ILogicalTable getDescriptorRows(ILogicalTable horizDataTableBody) {
        int endRow = DataTableBindHelper.getEndRowForDescriptorSection(horizDataTableBody);
        return (ILogicalTable)horizDataTableBody.getRows(0, endRow);
    }

    private static int getEndRowForDescriptorSection(ILogicalTable horizDataTableBody) {
        boolean hasForeignKeysRow = DataTableBindHelper.hasForeignKeysRow(horizDataTableBody);
        if (hasForeignKeysRow) {
            return 1;
        }
        return 0;
    }

    public static StringValue makeColumnTitle(IBindingContext bindingContext, ILogicalTable dataWithTitleRows, int column, boolean hasColumnTitleRow) {
        String value = "";
        if (hasColumnTitleRow) {
            ILogicalTable titleCell = (ILogicalTable)dataWithTitleRows.getSubtable(column, 0, 1, 1);
            value = titleCell.getSource().getCell(0, 0).getStringValue();
            value = StringUtils.trimToEmpty((String)value);
            return new StringValue(value, value, value, (IOpenSourceCodeModule)new GridCellSourceCodeModule(titleCell.getSource(), bindingContext));
        }
        return new StringValue(value, value, value, null);
    }

    public static ColumnDescriptor[] makeDescriptors(IBindingContext bindingContext, ITable table, IOpenClass type, OpenL openl, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows, boolean hasForeignKeysRow, boolean hasColumnTytleRow) throws Exception {
        int width = descriptorRows.getWidth();
        ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[width];
        List<IdentifierNode[]> columnIdentifiers = DataTableBindHelper.getColumnIdentifiers(bindingContext, table, descriptorRows);
        for (int columnNum = 0; columnNum < columnIdentifiers.size(); ++columnNum) {
            ColumnDescriptor currentColumnDescriptor;
            IdentifierNode[] fieldAccessorChainTokens = columnIdentifiers.get(columnNum);
            if (fieldAccessorChainTokens == null) continue;
            IOpenField descriptorField = null;
            boolean constructorField = false;
            IdentifierNode foreignKeyTable = null;
            IdentifierNode foreignKey = null;
            Object[] accessorChainTokens = null;
            ICell foreignKeyCell = null;
            if (fieldAccessorChainTokens.length == 1 && !hasForeignKeysRow) {
                IdentifierNode fieldNameNode = fieldAccessorChainTokens[0];
                if (CONSTRUCTOR_FIELD.equals(fieldNameNode.getIdentifier())) {
                    constructorField = true;
                } else {
                    descriptorField = fieldNameNode.getIdentifier().matches(ARRAY_ACCESS_PATTERN) ? DataTableBindHelper.getWritableArrayElement(fieldNameNode, table, type) : DataTableBindHelper.getWritableField(fieldNameNode, table, type);
                }
            } else {
                descriptorField = DataTableBindHelper.processFieldsChain(table, type, fieldAccessorChainTokens);
            }
            if (hasForeignKeysRow) {
                IdentifierNode[] foreignKeyTokens = DataTableBindHelper.getForeignKeyTokens(bindingContext, descriptorRows, columnNum);
                foreignKeyTable = foreignKeyTokens.length > 0 ? foreignKeyTokens[0] : null;
                foreignKey = foreignKeyTokens.length > 1 ? foreignKeyTokens[1] : null;
                foreignKeyCell = ((ILogicalTable)descriptorRows.getSubtable(columnNum, 1, 1, 1)).getSource().getCell(0, 0);
                if (foreignKeyTable != null && !ArrayUtils.isEmpty((Object[])(accessorChainTokens = Tokenizer.tokenize((IOpenSourceCodeModule)foreignKeyTable.getModule(), (String)LINK_DELIMETERS, (ILocation)foreignKeyTable.getLocation())))) {
                    foreignKeyTable = accessorChainTokens.length > 0 ? accessorChainTokens[0] : null;
                }
            }
            StringValue header = DataTableBindHelper.makeColumnTitle(bindingContext, dataWithTitleRows, columnNum, hasColumnTytleRow);
            columnDescriptors[columnNum] = currentColumnDescriptor = DataTableBindHelper.getColumnDescriptor(openl, descriptorField, constructorField, foreignKeyTable, foreignKey, accessorChainTokens, foreignKeyCell, header, fieldAccessorChainTokens);
        }
        return columnDescriptors;
    }

    public static List<IdentifierNode[]> getColumnIdentifiers(IBindingContext bindingContext, ITable table, ILogicalTable descriptorRows) {
        int width = descriptorRows.getWidth();
        ArrayList<IdentifierNode[]> identifiers = new ArrayList<IdentifierNode[]>();
        for (int columnNum = 0; columnNum < width; ++columnNum) {
            GridCellSourceCodeModule cellSourceModule = DataTableBindHelper.getCellSourceModule(descriptorRows, columnNum);
            cellSourceModule.update(bindingContext);
            String code = cellSourceModule.getCode();
            if (code.length() != 0) {
                IdentifierNode[] fieldAccessorChainTokens = null;
                try {
                    fieldAccessorChainTokens = Tokenizer.tokenize((IOpenSourceCodeModule)cellSourceModule, (String)CODE_DELIMETERS);
                }
                catch (OpenLCompilationException e) {
                    String message = String.format("Cannot parse field source \"%s\"", code);
                    SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceModule);
                    DataTableBindHelper.processError(table, error);
                }
                if (DataTableBindHelper.contains(identifiers, fieldAccessorChainTokens)) {
                    String message = String.format("Found duplicate of field \"%s\"", code);
                    SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceModule);
                    DataTableBindHelper.processError(table, error);
                    continue;
                }
                identifiers.add(fieldAccessorChainTokens);
                continue;
            }
            identifiers.add(null);
        }
        return identifiers;
    }

    private static GridCellSourceCodeModule getCellSourceModule(ILogicalTable descriptorRows, int columnNum) {
        IGridTable gridTable = ((ILogicalTable)descriptorRows.getColumn(columnNum)).getSource();
        GridCellSourceCodeModule cellSourceModule = new GridCellSourceCodeModule(gridTable);
        return cellSourceModule;
    }

    private static ColumnDescriptor getColumnDescriptor(OpenL openl, IOpenField descriptorField, boolean constructorField, IdentifierNode foreignKeyTable, IdentifierNode foreignKey, IdentifierNode[] foreignKeyTableAccessorChainTokens, ICell foreignKeyCell, StringValue header, IdentifierNode[] fieldChainTokens) {
        ColumnDescriptor currentColumnDescriptor = foreignKeyTable != null ? new ForeignKeyColumnDescriptor(descriptorField, foreignKeyTable, foreignKey, foreignKeyTableAccessorChainTokens, foreignKeyCell, header, openl, constructorField, fieldChainTokens) : new ColumnDescriptor(descriptorField, header, openl, constructorField, fieldChainTokens);
        return currentColumnDescriptor;
    }

    private static IOpenField processFieldsChain(ITable table, IOpenClass type, IdentifierNode[] fieldAccessorChainTokens) {
        FieldChain chainField = null;
        IOpenClass loadedFieldType = type;
        Object[] fieldAccessorChain = new IOpenField[fieldAccessorChainTokens.length];
        boolean hasAccessByArrayId = false;
        for (int fieldIndex = 0; fieldIndex < fieldAccessorChain.length; ++fieldIndex) {
            IOpenField fieldInChain;
            IdentifierNode fieldNameNode = fieldAccessorChainTokens[fieldIndex];
            boolean arrayAccess = fieldNameNode.getIdentifier().matches(ARRAY_ACCESS_PATTERN);
            if (fieldNameNode.getIdentifier().matches(PRECISION_PATTERN)) {
                fieldAccessorChain = (IOpenField[])ArrayUtils.remove((Object[])fieldAccessorChain, (int)fieldIndex);
                fieldAccessorChainTokens = (IdentifierNode[])ArrayUtils.remove((Object[])fieldAccessorChainTokens, (int)fieldIndex);
                continue;
            }
            if (arrayAccess) {
                hasAccessByArrayId = arrayAccess;
                fieldInChain = DataTableBindHelper.getWritableArrayElement(fieldNameNode, table, loadedFieldType);
            } else {
                fieldInChain = DataTableBindHelper.getWritableField(fieldNameNode, table, loadedFieldType);
            }
            if (fieldIndex > 0 && (fieldAccessorChain[fieldIndex - 1] instanceof DatatypeArrayElementField || fieldAccessorChain[fieldIndex - 1] instanceof SpreadsheetResultField) && fieldAccessorChain[fieldIndex - 1].getType().getOpenClass().equals(JavaOpenClass.OBJECT) && fieldNameNode.getIdentifier().matches(SPREADSHEETRESULTFIELD_PATTERN)) {
                AOpenField aOpenField = (AOpenField)fieldAccessorChain[fieldIndex - 1];
                aOpenField.setType((IOpenClass)new SpreadsheetResultOpenClass(SpreadsheetResult.class));
            }
            if (fieldInChain == null) break;
            loadedFieldType = fieldInChain.getType() != null && fieldInChain.getType().isArray() && arrayAccess ? fieldInChain.getType().getComponentClass() : fieldInChain.getType();
            fieldAccessorChain[fieldIndex] = fieldInChain;
        }
        if (!ArrayTool.contains((Object)fieldAccessorChain, null)) {
            chainField = new FieldChain(type, (IOpenField[])fieldAccessorChain, fieldAccessorChainTokens, hasAccessByArrayId);
        }
        return chainField;
    }

    public static Integer getPrecisionValue(IdentifierNode fieldNameNode) {
        try {
            String fieldName = fieldNameNode.getIdentifier();
            String txtIndex = fieldName.substring(fieldName.indexOf("(") + 1, fieldName.indexOf(")"));
            return Integer.parseInt(txtIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getArrayIndex(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        String txtIndex = fieldName.substring(fieldName.indexOf("[") + 1, fieldName.indexOf("]"));
        return Integer.parseInt(txtIndex);
    }

    private static String getArrayName(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        return fieldName.substring(0, fieldName.indexOf("["));
    }

    private static void processError(ITable table, SyntaxNodeException error) {
        if (table != null) {
            if (table.getTableSyntaxNode() != null) {
                table.getTableSyntaxNode().addError(error);
            }
            BindHelper.processError((SyntaxNodeException)error);
        }
    }

    private static IdentifierNode[] getForeignKeyTokens(IBindingContext bindingContext, ILogicalTable descriptorRows, int columnNum) throws OpenLCompilationException {
        ILogicalTable logicalRegion = (ILogicalTable)descriptorRows.getSubtable(columnNum, 1, 1, 1);
        GridCellSourceCodeModule indexRowSourceModule = new GridCellSourceCodeModule(logicalRegion.getSource(), bindingContext);
        return Tokenizer.tokenize((IOpenSourceCodeModule)indexRowSourceModule, (String)INDEX_ROW_REFERENCE_DELIMITER);
    }

    private static IOpenField getWritableField(IdentifierNode currentFieldNameNode, ITable table, IOpenClass loadedFieldType) {
        String fieldName = currentFieldNameNode.getIdentifier();
        IOpenField field = DataTableBindHelper.findField(fieldName, table, loadedFieldType);
        if (field == null && loadedFieldType.equals(JavaOpenClass.OBJECT)) {
            field = DataTableBindHelper.findField(fieldName, table, (IOpenClass)new SpreadsheetResultOpenClass(SpreadsheetResult.class));
        }
        if (field == null) {
            String errorMessage = String.format("Field \"%s\" not found in %s", fieldName, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)currentFieldNameNode);
            DataTableBindHelper.processError(table, error);
            return null;
        }
        if (!field.isWritable()) {
            String message = String.format("Field '%s' is not writable in %s", fieldName, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            DataTableBindHelper.processError(table, error);
            return null;
        }
        return field;
    }

    private static IOpenField getWritableArrayElement(IdentifierNode currentFieldNameNode, ITable table, IOpenClass loadedFieldType) {
        String arrayName = DataTableBindHelper.getArrayName(currentFieldNameNode);
        int arrayIndex = DataTableBindHelper.getArrayIndex(currentFieldNameNode);
        IOpenField field = DataTableBindHelper.findField(arrayName, table, loadedFieldType);
        if (field == null && loadedFieldType.equals(JavaOpenClass.OBJECT)) {
            field = DataTableBindHelper.findField(arrayName, table, (IOpenClass)new SpreadsheetResultOpenClass(SpreadsheetResult.class));
        }
        if (!field.getType().isArray() && !field.getType().getOpenClass().getInstanceClass().equals(Object.class)) {
            String message = String.format("Field '%s' isn't array! The field type is '%s'", arrayName, field.getType().toString());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            DataTableBindHelper.processError(table, error);
            return null;
        }
        DatatypeArrayElementField arrayAccessField = null;
        arrayAccessField = !field.getType().isArray() && field.getType().getOpenClass().getInstanceClass().equals(Object.class) ? new DatatypeArrayElementField(field, arrayIndex, (IOpenClass)JavaOpenClass.OBJECT) : new DatatypeArrayElementField(field, arrayIndex);
        if (!arrayAccessField.isWritable()) {
            String message = String.format("Field '%s' is not writable in %s", arrayName, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            DataTableBindHelper.processError(table, error);
            return null;
        }
        return arrayAccessField;
    }

    private static boolean contains(List<IdentifierNode[]> identifiers, IdentifierNode[] identifier) {
        for (IdentifierNode[] existIdentifier : identifiers) {
            if (!DataTableBindHelper.isEqualsIdentifier(existIdentifier, identifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualsIdentifier(IdentifierNode[] identifier1, IdentifierNode[] identifier2) {
        if (identifier1 == null || identifier2 == null) {
            return false;
        }
        if (identifier1.length != identifier2.length) {
            return false;
        }
        for (int i = 0; i < identifier1.length; ++i) {
            if (identifier1[i].getIdentifier().equals(identifier2[i].getIdentifier())) continue;
            return false;
        }
        return true;
    }
}

