/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.util.ArrayTool;

public class DatatypeHelper {
    public static IDomain<?> getTypeDomain(ILogicalTable table, IOpenClass type, OpenL openl, IBindingContext cxt) throws SyntaxNodeException {
        Object values;
        if (table != null && (values = DatatypeHelper.loadAliasDatatypeValues(table, type, openl, cxt)) != null) {
            return new EnumDomain(ArrayTool.toArray((Object)values));
        }
        return new EnumDomain(new Object[0]);
    }

    public static Object loadAliasDatatypeValues(ILogicalTable table, IOpenClass type, OpenL openl, IBindingContext cxt) throws SyntaxNodeException {
        OpenlToolAdaptor openlAdaptor = new OpenlToolAdaptor(openl, cxt);
        return RuleRowHelper.loadParam(table, type, "Values", "", openlAdaptor, true);
    }

    public static ILogicalTable getNormalizedDataPartTable(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        int horizontalCount;
        ILogicalTable dataPart = null;
        dataPart = PropertiesHelper.getPropertiesTableSection(table) != null ? (ILogicalTable)table.getRows(2) : (ILogicalTable)table.getRows(1);
        if (dataPart == null) {
            return null;
        }
        if (dataPart.getHeight() == 1) {
            return dataPart;
        }
        if (dataPart.getWidth() == 1) {
            return (ILogicalTable)dataPart.transpose();
        }
        int verticalCount = DatatypeHelper.countTypes(dataPart, openl, cxt);
        if (verticalCount < (horizontalCount = DatatypeHelper.countTypes((ILogicalTable)dataPart.transpose(), openl, cxt))) {
            return (ILogicalTable)dataPart.transpose();
        }
        return dataPart;
    }

    private static int countTypes(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        int height = table.getHeight();
        int count = 0;
        for (int i = 0; i < height; ++i) {
            try {
                IOpenClass type = DatatypeHelper.makeType((ILogicalTable)table.getRow(i), openl, cxt);
                if (type == null) continue;
                ++count;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return count;
    }

    private static IOpenClass makeType(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), cxt);
        return OpenLManager.makeType((OpenL)openl, (IOpenSourceCodeModule)source, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
    }

    public static String getDatatypeName(TableSyntaxNode tsn) throws OpenLCompilationException {
        if (XlsNodeTypes.XLS_DATATYPE.equals((Object)tsn.getNodeType())) {
            IOpenSourceCodeModule src = tsn.getHeader().getModule();
            IdentifierNode[] parsedHeader = DatatypeHelper.tokenizeHeader(src);
            return parsedHeader[1].getIdentifier();
        }
        return null;
    }

    public static IdentifierNode[] tokenizeHeader(IOpenSourceCodeModule tableHeader) throws OpenLCompilationException {
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)tableHeader, (String)" \n\r");
        if (parsedHeader.length < 2) {
            String message = "Datatype table format: Datatype <typename>";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)tableHeader);
        }
        return parsedHeader;
    }
}

