/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TopologicalSort<T> {
    public Set<TopoGraphNode<T>> sort(Collection<TopoGraphNode<T>> nodes) throws IllegalStateException {
        LinkedHashSet<TopoGraphNode<T>> order = new LinkedHashSet<TopoGraphNode<T>>();
        HashSet<TopoGraphNode<T>> visited = new HashSet<TopoGraphNode<T>>();
        HashSet<TopoGraphNode<T>> alreadySeen = new HashSet<TopoGraphNode<T>>();
        for (TopoGraphNode<T> n : nodes) {
            alreadySeen.clear();
            this.visit(n, alreadySeen, visited, order);
        }
        return order;
    }

    private void visit(TopoGraphNode<T> n, Set<TopoGraphNode<T>> alreadySeen, Set<TopoGraphNode<T>> visited, LinkedHashSet<TopoGraphNode<T>> order) {
        if (alreadySeen.contains(n)) {
            return;
        }
        alreadySeen.add(n);
        if (!visited.contains(n)) {
            visited.add(n);
            for (TopoGraphNode<T> m : n.getDependents()) {
                this.visit(m, alreadySeen, visited, order);
            }
            order.add(n);
        }
        alreadySeen.remove(n);
    }

    public static class TopoGraphNode<T> {
        private List<TopoGraphNode<T>> dependencies = new ArrayList<TopoGraphNode<T>>();
        private T obj;

        public TopoGraphNode(T obj) {
            this.obj = obj;
        }

        public List<TopoGraphNode<T>> getDependents() {
            return this.dependencies;
        }

        public void addDependency(TopoGraphNode<T> node) {
            this.dependencies.add(node);
        }

        public T getObj() {
            return this.obj;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TopoGraphNode) {
                TopoGraphNode node = (TopoGraphNode)obj;
                return new EqualsBuilder().append(this.obj, node.getObj()).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.obj).toHashCode();
        }
    }
}

