/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.core.ReflectUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassWriter;
import org.openl.rules.datatype.gen.bean.writers.BeanByteCodeWriter;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.generation.JavaClassGeneratorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanByteCodeGenerator {
    private final Logger log = LoggerFactory.getLogger(BeanByteCodeGenerator.class);
    private List<BeanByteCodeWriter> writers = new ArrayList<BeanByteCodeWriter>();
    private byte[] generatedByteCode;
    private String beanName;
    private String beanNameWithPackage;

    public BeanByteCodeGenerator(String beanName) {
        this.beanName = beanName;
        this.beanNameWithPackage = JavaClassGeneratorHelper.replaceDots((String)beanName);
    }

    public byte[] generateClassByteCode() {
        if (this.generatedByteCode == null) {
            ClassWriter classWriter = new ClassWriter(0);
            for (BeanByteCodeWriter writer : this.writers) {
                writer.write(classWriter);
            }
            this.generatedByteCode = classWriter.toByteArray();
        }
        return this.generatedByteCode;
    }

    public Class<?> generateAndLoadBeanClass() {
        Class result = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (BeanByteCodeGenerator.isClassLoaderContainsClass(classLoader, this.beanName)) {
                result = classLoader.loadClass(this.beanName);
                this.log.debug("Bean {} is using previously loaded", (Object)this.beanName);
                return result;
            }
            this.generateClassByteCode();
            result = ReflectUtils.defineClass((String)this.beanName, (byte[])this.generatedByteCode, (ClassLoader)classLoader);
            this.log.debug("bean {} is using generated at runtime", (Object)this.beanName);
            return result;
        }
        catch (Exception ex) {
            this.log.error("{}", (Object)this, (Object)ex);
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
    }

    protected boolean addWriter(BeanByteCodeWriter writer) {
        if (writer != null) {
            this.writers.add(writer);
            return true;
        }
        return false;
    }

    protected String getBeanNameWithPackage() {
        return this.beanNameWithPackage;
    }

    public static boolean isClassLoaderContainsClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.beanName)) {
            return String.format("Bean with name: %s", this.beanName);
        }
        return super.toString();
    }
}

