/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.binding.MethodUtil;
import org.openl.rules.datatype.gen.DefaultFieldDescription;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.RecursiveFieldDescription;
import org.openl.rules.datatype.gen.types.writers.BooleanTypeWriter;
import org.openl.rules.datatype.gen.types.writers.CharTypeWriter;
import org.openl.rules.datatype.gen.types.writers.DateTypeWriter;
import org.openl.rules.datatype.gen.types.writers.DefaultConstructorTypeWriter;
import org.openl.rules.datatype.gen.types.writers.DefaultEmptyArrayConstructorTypeWriter;
import org.openl.rules.datatype.gen.types.writers.DoubleTypeWriter;
import org.openl.rules.datatype.gen.types.writers.FloatTypeWriter;
import org.openl.rules.datatype.gen.types.writers.LongTypeWriter;
import org.openl.rules.datatype.gen.types.writers.NumericTypeWriter;
import org.openl.rules.datatype.gen.types.writers.ObjectTypeWriter;
import org.openl.rules.datatype.gen.types.writers.StringTypeWriter;
import org.openl.rules.datatype.gen.types.writers.TypeWriter;
import org.openl.types.IOpenField;
import org.openl.util.generation.JavaClassGeneratorHelper;

public class ByteCodeGeneratorHelper {
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static Map<Class<?>, TypeWriter> typeWriters = new HashMap();

    private ByteCodeGeneratorHelper() {
    }

    public static String getJavaType(FieldDescription field) {
        if (field instanceof RecursiveFieldDescription) {
            return JavaClassGeneratorHelper.getJavaType((String)field.getCanonicalTypeName());
        }
        Class<?> fieldClass = field.getType();
        return ByteCodeGeneratorHelper.getJavaType(fieldClass);
    }

    public static String getJavaType(Class<?> fieldClass) {
        return String.valueOf(Type.getType(fieldClass));
    }

    public static TypeWriter getTypeWriter(FieldDescription field) {
        if (field.hasDefaultKeyWord()) {
            return new DefaultConstructorTypeWriter();
        }
        if (field.hasEmptyKeyWord() && field.getType().isArray()) {
            return new DefaultEmptyArrayConstructorTypeWriter();
        }
        Class<?> clazz = field.getType();
        return ByteCodeGeneratorHelper.getTypeWriter(clazz);
    }

    public static TypeWriter getTypeWriter(Class<?> clazz) {
        TypeWriter typeWriter = typeWriters.get(clazz);
        if (typeWriter == null && clazz instanceof Object) {
            return typeWriters.get(Object.class);
        }
        return typeWriter;
    }

    public static int getConstantForVarInsn(FieldDescription field) {
        Class<?> retClass = field.getType();
        return ByteCodeGeneratorHelper.getConstantForVarInsn(retClass);
    }

    public static int getConstantForVarInsn(Class<?> fieldClass) {
        TypeWriter typeWriter = ByteCodeGeneratorHelper.getTypeWriter(fieldClass);
        if (typeWriter != null) {
            return typeWriter.getConstantForVarInsn();
        }
        return 0;
    }

    public static String getMethodSignatureForByteCode(Map<String, FieldDescription> params, Class<?> returnType) {
        StringBuilder signatureBuilder = new StringBuilder("(");
        for (Map.Entry<String, FieldDescription> field : params.entrySet()) {
            String javaType = ByteCodeGeneratorHelper.getJavaType(field.getValue());
            signatureBuilder.append(javaType);
        }
        signatureBuilder.append(")");
        if (returnType == null) {
            signatureBuilder.append("V");
        } else {
            signatureBuilder.append(ByteCodeGeneratorHelper.getJavaType(returnType));
        }
        return signatureBuilder.toString();
    }

    public static Map<String, FieldDescription> convertFields(Map<String, IOpenField> fieldsToConvert) {
        LinkedHashMap<String, FieldDescription> fields = new LinkedHashMap<String, FieldDescription>();
        for (Map.Entry<String, IOpenField> field : fieldsToConvert.entrySet()) {
            fields.put(field.getKey(), new DefaultFieldDescription(field.getValue()));
        }
        return fields;
    }

    public static int getConstantForReturn(FieldDescription field) {
        Class<?> retClass = field.getType();
        return ByteCodeGeneratorHelper.getConstantForReturn(retClass);
    }

    public static int getConstantForReturn(Class<?> fieldClass) {
        TypeWriter typeWriter = ByteCodeGeneratorHelper.getTypeWriter(fieldClass);
        if (typeWriter != null) {
            return typeWriter.getConstantForReturn();
        }
        return 0;
    }

    public static String getSignature(Class<?> methodOwner, String methodName, Class<?>[] paramTypes) {
        Method matchingMethod = MethodUtil.getMatchingAccessibleMethod(methodOwner, (String)methodName, (Class[])paramTypes, (boolean)false);
        StringBuilder signatureBuilder = new StringBuilder();
        signatureBuilder.append('(');
        for (Class<?> paramType : matchingMethod.getParameterTypes()) {
            signatureBuilder.append(ByteCodeGeneratorHelper.getJavaType(paramType));
        }
        signatureBuilder.append(')');
        signatureBuilder.append(ByteCodeGeneratorHelper.getJavaType(matchingMethod.getReturnType()));
        return signatureBuilder.toString();
    }

    public static void invokeStatic(MethodVisitor methodVisitor, Class<?> methodOwner, String methodName, Class<?>[] paramTypes) {
        String signatureBuilder = ByteCodeGeneratorHelper.getSignature(methodOwner, methodName, paramTypes);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(methodOwner), methodName, signatureBuilder);
    }

    public static int getTwoStackElementFieldsCount(Map<String, FieldDescription> fields) {
        int twoStackElementsCount = 0;
        for (FieldDescription field : fields.values()) {
            if (!Long.TYPE.equals(field.getType()) && !Double.TYPE.equals(field.getType())) continue;
            ++twoStackElementsCount;
        }
        return twoStackElementsCount;
    }

    static {
        typeWriters.put(Byte.TYPE, new NumericTypeWriter());
        typeWriters.put(Short.TYPE, new NumericTypeWriter());
        typeWriters.put(Integer.TYPE, new NumericTypeWriter());
        typeWriters.put(Boolean.TYPE, new BooleanTypeWriter());
        typeWriters.put(Character.TYPE, new CharTypeWriter());
        typeWriters.put(Long.TYPE, new LongTypeWriter());
        typeWriters.put(Float.TYPE, new FloatTypeWriter());
        typeWriters.put(Double.TYPE, new DoubleTypeWriter());
        typeWriters.put(Date.class, new DateTypeWriter());
        typeWriters.put(String.class, new StringTypeWriter());
        typeWriters.put(Object.class, new ObjectTypeWriter());
    }
}

