/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import org.apache.commons.lang3.StringUtils;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.datatype.gen.DefaultFieldDescription;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public class RecursiveFieldDescription
implements FieldDescription {
    private DefaultFieldDescription field;

    public RecursiveFieldDescription(IOpenField field) {
        Class<Object> instanceClass = field.getType().getInstanceClass();
        if (instanceClass == null) {
            instanceClass = Object.class;
        }
        DefaultFieldDescription fieldDescription = new DefaultFieldDescription(instanceClass);
        fieldDescription.setCanonicalTypeName(this.getCanonicalTypeName(field));
        this.field = fieldDescription;
    }

    private String getCanonicalTypeName(IOpenField field) {
        IOpenClass type = DatatypeTableBoundNode.getRootComponentClass(field.getType());
        if (type instanceof DatatypeOpenClass && field.getType().getInstanceClass() == null) {
            String datatypeName = field.getType().getName();
            String packageName = ((DatatypeOpenClass)type).getPackageName();
            if (StringUtils.isBlank((CharSequence)packageName)) {
                return datatypeName;
            }
            return String.format("%s.%s", packageName, datatypeName);
        }
        throw new IllegalArgumentException("Unknown field got here");
    }

    @Override
    public String getCanonicalTypeName() {
        return this.field.getCanonicalTypeName();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public String getDefaultValueAsString() {
        return this.field.getDefaultValueAsString();
    }

    @Override
    public void setDefaultValue(Object value) {
        this.field.setDefaultValue(value);
    }

    @Override
    public void setDefaultValueAsString(String defaultValueAsString) {
        this.field.setDefaultValueAsString(defaultValueAsString);
    }

    @Override
    public boolean isArray() {
        return this.field.isArray();
    }

    @Override
    public Object getDefaultValue() {
        return this.field.getDefaultValue();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.field.hasDefaultValue();
    }

    @Override
    public boolean hasDefaultKeyWord() {
        return this.field.hasDefaultKeyWord();
    }

    @Override
    public boolean hasEmptyKeyWord() {
        return this.field.hasEmptyKeyWord();
    }
}

