/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openl.rules.datatype.gen.BeanByteCodeGenerator;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.ClassDescriptionWriter;
import org.openl.rules.datatype.gen.bean.writers.ConstructorWithParametersWriter;
import org.openl.rules.datatype.gen.bean.writers.DefaultConstructorWriter;
import org.openl.rules.datatype.gen.bean.writers.EqualsWriter;
import org.openl.rules.datatype.gen.bean.writers.GettersWriter;
import org.openl.rules.datatype.gen.bean.writers.HashCodeWriter;
import org.openl.rules.datatype.gen.bean.writers.JAXBAnnotationWriter;
import org.openl.rules.datatype.gen.bean.writers.ProtectedFieldsWriter;
import org.openl.rules.datatype.gen.bean.writers.SettersWriter;
import org.openl.rules.datatype.gen.bean.writers.ToStringWriter;

public class SimpleBeanByteCodeGenerator
extends BeanByteCodeGenerator {
    private Class<?> parentClass;
    private LinkedHashMap<String, FieldDescription> beanFields;
    private LinkedHashMap<String, FieldDescription> parentFields;
    private LinkedHashMap<String, FieldDescription> allFields;

    public SimpleBeanByteCodeGenerator(String beanName, Map<String, FieldDescription> beanFields) {
        this(beanName, beanFields, null, new LinkedHashMap<String, FieldDescription>());
    }

    public SimpleBeanByteCodeGenerator(String beanName, Map<String, FieldDescription> beanFields, Class<?> parentClass, Map<String, FieldDescription> parentFields) {
        super(beanName);
        this.beanFields = new LinkedHashMap<String, FieldDescription>(beanFields);
        this.parentFields = new LinkedHashMap<String, FieldDescription>(parentFields);
        this.parentClass = parentClass;
        this.allFields = new LinkedHashMap();
        this.allFields.putAll(parentFields);
        this.allFields.putAll(beanFields);
        this.initWriters();
    }

    private void initWriters() {
        this.addWriter(new ClassDescriptionWriter(this.getBeanNameWithPackage(), this.parentClass));
        this.addWriter(new JAXBAnnotationWriter(this.getBeanNameWithPackage()));
        this.addWriter(new ProtectedFieldsWriter(this.beanFields));
        this.addWriter(new DefaultConstructorWriter(this.getBeanNameWithPackage(), this.parentClass, this.beanFields));
        if (this.allFields.size() < 256) {
            this.addWriter(new ConstructorWithParametersWriter(this.getBeanNameWithPackage(), this.parentClass, this.beanFields, this.parentFields, this.allFields));
        }
        this.addWriter(new GettersWriter(this.getBeanNameWithPackage(), this.beanFields));
        this.addWriter(new SettersWriter(this.getBeanNameWithPackage(), this.beanFields));
        this.addWriter(new ToStringWriter(this.getBeanNameWithPackage(), this.allFields));
        this.addWriter(new EqualsWriter(this.getBeanNameWithPackage(), this.allFields));
        this.addWriter(new HashCodeWriter(this.getBeanNameWithPackage(), this.allFields));
    }
}

