/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;
import org.openl.rules.datatype.gen.types.writers.TypeWriter;

public class DefaultConstructorWriter
extends DefaultBeanByteCodeWriter {
    public DefaultConstructorWriter(String beanNameWithPackage, Class<?> parentClass, Map<String, FieldDescription> beanFields) {
        super(beanNameWithPackage, parentClass, beanFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        MethodVisitor methodVisitor = this.writeDefaultConstructorDefinition(classWriter);
        String parentName = this.getParentInternalName();
        methodVisitor.visitMethodInsn(183, parentName, "<init>", "()V");
        int stackVariable = this.writeDefaultFieldValues(methodVisitor);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(stackVariable, 1);
    }

    protected MethodVisitor writeDefaultConstructorDefinition(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitVarInsn(25, 0);
        return methodVisitor;
    }

    private int writeDefaultFieldValues(MethodVisitor methodVisitor) {
        int result = 1;
        if (this.isAnyDefaultValue()) {
            result = this.writeAtLeast1DefaultValue(methodVisitor);
        }
        return result;
    }

    private int writeAtLeast1DefaultValue(MethodVisitor methodVisitor) {
        int minStackVariable = 2;
        int[] stackVariables = new int[this.getBeanFields().entrySet().size()];
        int index = 0;
        for (Map.Entry<String, FieldDescription> field : this.getBeanFields().entrySet()) {
            FieldDescription fieldDescription = field.getValue();
            if (fieldDescription.hasDefaultValue()) {
                methodVisitor.visitVarInsn(25, 0);
                TypeWriter typeWriter = ByteCodeGeneratorHelper.getTypeWriter(fieldDescription);
                stackVariables[index] = typeWriter.writeFieldValue(methodVisitor, fieldDescription);
                String fieldTypeName = ByteCodeGeneratorHelper.getJavaType(fieldDescription);
                methodVisitor.visitFieldInsn(181, this.getBeanNameWithPackage(), field.getKey(), fieldTypeName);
            } else {
                stackVariables[index] = minStackVariable;
            }
            ++index;
        }
        return NumberUtils.max((int[])stackVariables);
    }

    private boolean isAnyDefaultValue() {
        for (Map.Entry<String, FieldDescription> field : this.getBeanFields().entrySet()) {
            Object defaultValue = field.getValue().getDefaultValue();
            if (defaultValue == null) continue;
            return true;
        }
        return false;
    }
}

