/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;

public abstract class MethodWriter
extends DefaultBeanByteCodeWriter {
    public static final String VOID_CLASS_NAME = "void";
    private int twoStackElementFieldsCount;

    public MethodWriter(String beanNameWithPackage, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, null, allFields);
        this.twoStackElementFieldsCount = ByteCodeGeneratorHelper.getTwoStackElementFieldsCount(allFields);
    }

    @Override
    protected String getBeanNameWithPackage() {
        return super.getBeanNameWithPackage();
    }

    protected Map<String, FieldDescription> getAllFields() {
        return this.getBeanFields();
    }

    protected int getTwoStackElementFieldsCount() {
        return this.twoStackElementFieldsCount;
    }

    protected void pushFieldToStack(MethodVisitor codeVisitor, int fieldOwnerLocalVarIndex, String fieldName) {
        codeVisitor.visitVarInsn(25, fieldOwnerLocalVarIndex);
        codeVisitor.visitFieldInsn(180, this.getBeanNameWithPackage(), fieldName, ByteCodeGeneratorHelper.getJavaType(this.getAllFields().get(fieldName)));
    }

    public static boolean containRestrictedSymbols(String fieldName) {
        String regex = "^(_|[a-zA-Z]|\\$)(_|[a-zA-Z0-9]|\\$)*";
        return !fieldName.matches(regex);
    }

    protected boolean validField(String fieldName, FieldDescription fieldDescription) {
        return !fieldDescription.getCanonicalTypeName().equals(VOID_CLASS_NAME) && !MethodWriter.containRestrictedSymbols(fieldName);
    }
}

