/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openl.rules.datatype.gen.ByteCodeGeneratorHelper;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.MethodWriter;
import org.openl.util.StringTool;

public class SettersWriter
extends MethodWriter {
    public SettersWriter(String beanNameWithPackage, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        for (Map.Entry<String, FieldDescription> field : this.getAllFields().entrySet()) {
            if (!this.validField(field.getKey(), field.getValue())) continue;
            this.generateSetter(classWriter, field);
        }
    }

    protected void generateSetter(ClassWriter classWriter, Map.Entry<String, FieldDescription> fieldEntry) {
        String fieldName = fieldEntry.getKey();
        FieldDescription field = fieldEntry.getValue();
        MethodVisitor methodVisitor = this.writeMethodSignature(classWriter, field, fieldName);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(ByteCodeGeneratorHelper.getConstantForVarInsn(field), 1);
        methodVisitor.visitFieldInsn(181, this.getBeanNameWithPackage(), fieldName, ByteCodeGeneratorHelper.getJavaType(field));
        methodVisitor.visitInsn(177);
        if (Long.TYPE.equals(field.getType()) || Double.TYPE.equals(field.getType())) {
            methodVisitor.visitMaxs(3, 3);
        } else {
            methodVisitor.visitMaxs(2, 2);
        }
    }

    protected MethodVisitor writeMethodSignature(ClassWriter classWriter, FieldDescription fieldType, String fieldName) {
        String setterName = StringTool.getSetterName((String)fieldName);
        String javaType = ByteCodeGeneratorHelper.getJavaType(fieldType);
        String format = new StringBuilder(64).append('(').append(javaType).append(")V").toString();
        return classWriter.visitMethod(1, setterName, format, null, null);
    }
}

