/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.types.writers;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.types.writers.TypeWriter;

public class DefaultEmptyArrayConstructorTypeWriter
implements TypeWriter {
    @Override
    public int getConstantForVarInsn() {
        return 25;
    }

    @Override
    public int getConstantForReturn() {
        return 176;
    }

    @Override
    public int writeFieldValue(MethodVisitor methodVisitor, FieldDescription field) {
        if (!field.getType().isArray()) {
            throw new IllegalArgumentException("Field type is not an array!");
        }
        Class<?> type = field.getType().getComponentType();
        if (!type.isArray()) {
            String internalName = Type.getInternalName(type);
            methodVisitor.visitInsn(3);
            methodVisitor.visitTypeInsn(189, internalName);
        } else {
            int level = 1;
            while (type.isArray()) {
                type = type.getComponentType();
                ++level;
            }
            String internalName = Type.getDescriptor(field.getType());
            for (int i = 0; i < level; ++i) {
                methodVisitor.visitInsn(3);
            }
            methodVisitor.visitMultiANewArrayInsn(internalName, level);
        }
        return 5;
    }
}

