/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.domaintype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openl.binding.exception.FieldNotFoundException;
import org.openl.meta.IVocabulary;
import org.openl.meta.StringValue;
import org.openl.rules.domaintype.DomainAttribute;
import org.openl.rules.domaintype.DomainCreator;
import org.openl.rules.domaintype.ModifiableOpenClass;
import org.openl.rules.domaintype.ModifiedField;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.StringTool;

public class RulesVocabulary
implements IVocabulary {
    HashMap<String, IOpenClass> newTypes = new HashMap();

    public DomainAttribute[] getAttributes() {
        return new DomainAttribute[0];
    }

    public DomainCreator[] getDomains() {
        return new DomainCreator[0];
    }

    public IOpenClass[] getVocabularyTypes() throws SyntaxNodeException {
        ArrayList<IOpenClass> list = this.makeBaseTypes();
        this.makeDomains(list);
        for (IOpenClass ioc : list) {
            this.newTypes.put(ioc.getName(), ioc);
        }
        this.makeDomainAttributes(list);
        return list.toArray(IOpenClass.EMPTY);
    }

    ArrayList<IOpenClass> makeBaseTypes() {
        ArrayList<IOpenClass> list = new ArrayList<IOpenClass>();
        DomainCreator[] dc = this.getDomains();
        for (int i = 0; i < dc.length; ++i) {
            IOpenClass newType = dc[i].makeDomain();
            list.add(newType);
        }
        return list;
    }

    void makeDomainAttributes(ArrayList<IOpenClass> list) throws SyntaxNodeException {
        DomainAttribute[] attributes = this.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            StringValue fieldName = attributes[i].getName();
            IOpenField field = attributes[i].getBase().getField(fieldName.getValue(), true);
            if (field == null) {
                try {
                    throw new FieldNotFoundException("Can not find attribute", fieldName.getValue(), null);
                }
                catch (FieldNotFoundException e) {
                    throw SyntaxNodeExceptionUtils.createError(null, (Throwable)e, null, (IOpenSourceCodeModule)fieldName.asSourceCodeModule());
                }
            }
            StringValue typeName = attributes[i].getNewType();
            IOpenClass newType = this.newTypes.get(typeName.getValue());
            if (newType == null) {
                try {
                    throw new Exception("Type not found: " + typeName);
                }
                catch (Exception e) {
                    throw SyntaxNodeExceptionUtils.createError(null, (Throwable)e, null, (IOpenSourceCodeModule)typeName.asSourceCodeModule());
                }
            }
            String baseName = attributes[i].getBase().getName();
            String xname = StringTool.lastToken((String)baseName, (String)".");
            ModifiableOpenClass modifiedBase = (ModifiableOpenClass)this.newTypes.get(xname);
            if (modifiedBase == null) {
                modifiedBase = new ModifiableOpenClass(attributes[i].getBase(), xname);
                this.newTypes.put(xname, (IOpenClass)modifiedBase);
                list.add((IOpenClass)modifiedBase);
            }
            ModifiedField mf = new ModifiedField(field, newType);
            modifiedBase.addField((IOpenField)mf);
        }
    }

    public void makeDomains(List<IOpenClass> list) {
    }
}

