/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.annotations.Executable;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DTInfo;
import org.openl.rules.dt.DecisionTableInvoker;
import org.openl.rules.dt.algorithm.DecisionTableAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm2.DecisionTableAlgorithmBuilder2;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dtx.IBaseAction;
import org.openl.rules.dtx.IBaseCondition;
import org.openl.rules.dtx.IBaseDecisionRow;
import org.openl.rules.dtx.IDecisionTable;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.types.impl.CompositeMethod;
import org.openl.vm.IRuntimeEnv;

@Executable
public class DecisionTable
extends ExecutableRulesMethod
implements IDecisionTable {
    private IBaseCondition[] conditionRows;
    private IBaseAction[] actionRows;
    private RuleRow ruleRow;
    private int columns;
    private IDecisionTableAlgorithm algorithm;
    private Invokable invoker;
    private DTInfo dtInfo;
    public static boolean ALG2 = false;

    public DecisionTable() {
        super(null, null);
    }

    public DecisionTable(IOpenMethodHeader header, AMethodBasedNode boundNode) {
        super(header, boundNode);
        this.initProperties(this.getSyntaxNode().getTableProperties());
    }

    @Override
    public IBaseAction[] getActionRows() {
        return this.actionRows;
    }

    public IDecisionTableAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getColumns() {
        return this.columns;
    }

    @Override
    public IBaseCondition[] getConditionRows() {
        return this.conditionRows;
    }

    public String getDisplayName(int mode) {
        IMemberMetaInfo metaInfo = this.getHeader().getInfo();
        if (metaInfo != null) {
            return metaInfo.getDisplayName(mode);
        }
        return this.toString();
    }

    @Override
    public IOpenMethod getMethod() {
        return this;
    }

    @Override
    public int getNumberOfRules() {
        if (this.actionRows.length > 0) {
            return this.actionRows[0].getNumberOfRules();
        }
        return 0;
    }

    @Override
    public String getRuleName(int col) {
        return this.ruleRow == null ? "R" + (col + 1) : this.ruleRow.getRuleName(col);
    }

    public RuleRow getRuleRow() {
        return this.ruleRow;
    }

    @Override
    public ILogicalTable getRuleTable(int ruleIndex) {
        ILogicalTable dt = this.actionRows[0].getDecisionTable();
        int starColumn = dt.getWidth() - this.columns;
        return (ILogicalTable)dt.getColumn(starColumn + ruleIndex);
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    public void setActionRows(IAction[] actionRows) {
        this.actionRows = actionRows;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setConditionRows(IBaseCondition[] conditionRows) {
        this.conditionRows = conditionRows;
    }

    public void setRuleRow(RuleRow ruleRow) {
        this.ruleRow = ruleRow;
    }

    public void bindTable(IBaseCondition[] conditionRows, IBaseAction[] actionRows, RuleRow ruleRow, OpenL openl, ComponentOpenClass componentOpenClass, IBindingContextDelegator cxtd, int columns) throws Exception {
        this.conditionRows = conditionRows;
        this.actionRows = actionRows;
        if (!cxtd.isExecutionMode()) {
            this.ruleRow = ruleRow;
        }
        this.columns = columns;
        this.prepare(this.getHeader(), openl, componentOpenClass, cxtd);
    }

    @Override
    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    @Override
    protected Object innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        if (this.invoker == null) {
            this.invoker = new DecisionTableInvoker(this);
        }
        return this.invoker.invoke(target, params, env);
    }

    public boolean shouldFailOnMiss() {
        if (this.getMethodProperties() != null) {
            return (Boolean)this.getMethodProperties().getPropertyValue("failOnMiss");
        }
        return false;
    }

    private void prepare(IOpenMethodHeader header, OpenL openl, ComponentOpenClass module, IBindingContextDelegator bindingContextDelegator) throws Exception {
        this.algorithm = this.getAlgorithmBuilder(header, openl, module, bindingContextDelegator).prepareAndBuildAlgorithm();
    }

    private IAlgorithmBuilder getAlgorithmBuilder(IOpenMethodHeader header, OpenL openl, ComponentOpenClass module, IBindingContextDelegator bindingContextDelegator) {
        return ALG2 ? new DecisionTableAlgorithmBuilder2(this, header, openl, module, bindingContextDelegator) : new DecisionTableAlgorithmBuilder(this, header, openl, module, bindingContextDelegator);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
        CompositeMethod method;
        if (this.conditionRows != null) {
            for (IBaseDecisionRow iBaseDecisionRow : this.conditionRows) {
                method = (CompositeMethod)iBaseDecisionRow.getMethod();
                if (method != null) {
                    method.updateDependency(dependencies);
                }
                this.updateValueDependency((FunctionalRow)iBaseDecisionRow, dependencies);
            }
        }
        if (this.actionRows != null) {
            for (IBaseDecisionRow iBaseDecisionRow : this.actionRows) {
                method = (CompositeMethod)iBaseDecisionRow.getMethod();
                if (method != null) {
                    method.updateDependency(dependencies);
                }
                this.updateValueDependency((FunctionalRow)iBaseDecisionRow, dependencies);
            }
        }
    }

    protected void updateValueDependency(FunctionalRow frow, BindingDependencies dependencies) {
        int len = frow.getNumberOfRules();
        int np = frow.getNumberOfParams();
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            if (frow.isEmpty(ruleN)) continue;
            for (int paramIndex = 0; paramIndex < np; ++paramIndex) {
                Object value = frow.getParamValue(paramIndex, ruleN);
                if (value instanceof CompositeMethod) {
                    ((CompositeMethod)value).updateDependency(dependencies);
                    continue;
                }
                if (!(value instanceof ArrayHolder)) continue;
                ArrayHolder ah = (ArrayHolder)value;
                ah.updateDependency(dependencies);
            }
        }
    }

    public ICondition getCondition(int n) {
        return (ICondition)this.conditionRows[n];
    }

    public IAction getAction(int n) {
        return (IAction)this.actionRows[n];
    }

    public DTInfo getDtInfo() {
        return this.dtInfo;
    }

    public void setDtInfo(DTInfo dtInfo) {
        this.dtInfo = dtInfo;
    }

    @Override
    public int getNumberOfConditions() {
        return this.conditionRows.length;
    }

    public int getNumberOfActions() {
        return this.actionRows.length;
    }
}

