/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.load.SimpleSheetLoader;
import org.openl.rules.lang.xls.load.SimpleWorkbookLoader;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.types.IOpenClass;

public class DecisionTableHelper {
    public static boolean looksLikeVertical(ILogicalTable table) {
        int cnt2;
        if (table.getWidth() <= 4) {
            return true;
        }
        if (table.getHeight() <= 4) {
            return false;
        }
        int cnt1 = DecisionTableHelper.countConditionsAndActions(table);
        if (cnt1 != (cnt2 = DecisionTableHelper.countConditionsAndActions((ILogicalTable)table.transpose()))) {
            return cnt1 > cnt2;
        }
        return table.getWidth() <= 4;
    }

    public static boolean isValidConditionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.CONDITION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    public static boolean isValidHConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    public static boolean isValidMergedConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    public static boolean isValidActionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.ACTION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    public static boolean isValidRetHeader(String s) {
        return s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.RETURN.getHeaderKey()) && (s.length() == 3 || Character.isDigit(s.charAt(3)));
    }

    public static boolean isValidRuleHeader(String s) {
        return s.equals(DecisionTableColumnHeaders.RULE.getHeaderKey());
    }

    public static boolean isActionHeader(String s) {
        return DecisionTableHelper.isValidActionHeader(s) || DecisionTableHelper.isValidRetHeader(s);
    }

    public static boolean isConditionHeader(String s) {
        return DecisionTableHelper.isValidConditionHeader(s) || DecisionTableHelper.isValidHConditionHeader(s) || DecisionTableHelper.isValidMergedConditionHeader(s);
    }

    public static int countConditionsAndActions(ILogicalTable table) {
        int width = table.getWidth();
        int count = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null) continue;
            count += DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) || DecisionTableHelper.isActionHeader(value) ? 1 : 0;
        }
        return count;
    }

    public static boolean hasHConditions(ILogicalTable table) {
        return DecisionTableHelper.countHConditions(table) > 0;
    }

    public static ILogicalTable preprocessSimpleDecisionTable(DecisionTable decisionTable, ILogicalTable originalTable, int numberOfHcondition) throws OpenLCompilationException {
        XlsSheetGridModel virtualGrid = DecisionTableHelper.createVirtualGrid();
        DecisionTableHelper.writeVirtualHeadersForSimpleDecisionTable(virtualGrid, originalTable, decisionTable, numberOfHcondition);
        int sizeOfVirtualGridTable = virtualGrid.getMaxColumnIndex(0) < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGrid.getMaxColumnIndex(0) - 1;
        GridTable virtualGridTable = new GridTable(0, 0, 2, sizeOfVirtualGridTable, virtualGrid);
        CompositeGrid grid = new CompositeGrid(new IGridTable[]{virtualGridTable, originalTable.getSource()}, true);
        int sizeofGrid = virtualGridTable.getWidth() < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGridTable.getWidth() - 1;
        return LogicalTableHelper.logicalTable(new GridTable(0, 0, originalTable.getSource().getHeight() + 3 - 1, sizeofGrid, grid));
    }

    private static void writeVirtualHeadersForSimpleDecisionTable(IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int numberOfHcondition) throws OpenLCompilationException {
        int columnsForConditions = 0;
        columnsForConditions = DecisionTableHelper.writeConditions(grid, originalTable, decisionTable, numberOfHcondition);
        DecisionTableHelper.writeReturn(grid, originalTable, decisionTable, columnsForConditions, numberOfHcondition > 0);
    }

    private static void writeReturn(IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int columnsForConditions, boolean isLookupTable) throws OpenLCompilationException {
        int mergedColumnsCounts;
        grid.setCellValue(columnsForConditions, 0, (DecisionTableColumnHeaders.RETURN.getHeaderKey() + "1").intern());
        if (!isLookupTable && originalTable.getWidth() > DecisionTableHelper.getNumberOfConditions(decisionTable) && (mergedColumnsCounts = originalTable.getColumnWidth(DecisionTableHelper.getNumberOfConditions(decisionTable))) > 1) {
            for (int row = 0; row < 3; ++row) {
                grid.addMergedRegion(new GridRegion(row, columnsForConditions, row, columnsForConditions + mergedColumnsCounts - 1));
            }
        }
    }

    private static int writeConditions(IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int numberOfHcondition) throws OpenLCompilationException {
        int numberOfConditions = DecisionTableHelper.getNumberOfConditions(decisionTable);
        int column = 0;
        int vColumnCounter = 0;
        for (int i = 0; i < numberOfConditions; ++i) {
            boolean lastCondition;
            if (column > originalTable.getWidth()) {
                String message = "Wrong table structure: Columns count is less than parameters count";
                throw new OpenLCompilationException(message);
            }
            boolean isThatVCondition = i < numberOfConditions - numberOfHcondition;
            boolean bl = lastCondition = i + 1 == numberOfConditions;
            if (isThatVCondition) {
                ++vColumnCounter;
                if (i == 0 && numberOfHcondition == 0 && numberOfConditions < 2) {
                    grid.setCellValue(column, 0, (DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey() + (i + 1)).intern());
                } else {
                    grid.setCellValue(column, 0, (DecisionTableColumnHeaders.CONDITION.getHeaderKey() + (i + 1)).intern());
                }
            } else {
                grid.setCellValue(column, 0, (DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey() + (i + 1)).intern());
            }
            grid.setCellValue(column, 1, decisionTable.getSignature().getParameterName(i));
            grid.setCellValue(column, 2, DecisionTableHelper.checkTypeOfValues(originalTable, i, decisionTable.getSignature().getParameterTypes()[i], isThatVCondition, lastCondition, vColumnCounter));
            if (isThatVCondition || lastCondition) {
                int mergedColumnsCounts;
                int n = mergedColumnsCounts = isThatVCondition ? originalTable.getColumnWidth(i) : originalTable.getSource().getCell(vColumnCounter, i - vColumnCounter).getWidth();
                if (mergedColumnsCounts > 1) {
                    for (int row = 0; row < 3; ++row) {
                        grid.addMergedRegion(new GridRegion(row, column, row, column + mergedColumnsCounts - 1));
                    }
                }
                column += mergedColumnsCounts;
                continue;
            }
            ++column;
        }
        return column;
    }

    private static String checkTypeOfValues(ILogicalTable originalTable, int column, IOpenClass type, boolean isThatVCondition, boolean lastCondition, int vColumnCounter) {
        ILogicalTable decisionValues;
        List<String> intType = Arrays.asList("byte", "short", "int", "java.lang.Byte", "org.openl.meta.ByteValue", "org.openl.meta.ShortValue", "org.openl.meta.IntValue", "org.openl.meta.BigIntegerValue", "java.lang.Integer", "org.openl.meta.IntegerValue");
        List<String> doubleType = Arrays.asList("long", "float", "double", "java.lang.Long", "java.lang.Float", "java.lang.Double", "org.openl.meta.LongValue", "org.openl.meta.FloatValue", "org.openl.meta.DoubleValue", "org.openl.meta.BigDecimalValue");
        int width = 0;
        if (isThatVCondition) {
            decisionValues = (ILogicalTable)originalTable.getColumn(column);
            width = decisionValues.getHeight();
        } else {
            int numOfHRow = column - vColumnCounter;
            decisionValues = LogicalTableHelper.logicalTable((IGridTable)originalTable.getSource().getRow(numOfHRow));
            width = decisionValues.getWidth();
        }
        if (isThatVCondition || lastCondition) {
            boolean isMerged;
            int mergedColumnsCounts = isThatVCondition ? originalTable.getColumnWidth(column) : originalTable.getSource().getCell(vColumnCounter, column - vColumnCounter).getWidth();
            boolean bl = isMerged = mergedColumnsCounts > 1;
            if (isMerged) {
                if (!type.isArray()) {
                    return type.getName() + "[]";
                }
                return type.getName();
            }
        }
        for (int valueNum = 1; valueNum < width; ++valueNum) {
            ILogicalTable cellValue = isThatVCondition ? (ILogicalTable)decisionValues.getRow(valueNum) : (ILogicalTable)decisionValues.getColumn(valueNum);
            if (cellValue.getSource().getCell(0, 0).getStringValue() == null || !DecisionTableHelper.maybeIsRange(cellValue.getSource().getCell(0, 0).getStringValue())) continue;
            INumberRange range = null;
            if (intType.contains(type.getName())) {
                try {
                    range = new IntRange(cellValue.getSource().getCell(0, 0).getStringValue());
                    return range.getClass().getSimpleName();
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (!doubleType.contains(type.getName())) continue;
            try {
                range = new DoubleRange(cellValue.getSource().getCell(0, 0).getStringValue());
                return range.getClass().getSimpleName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!type.isArray()) {
            return type.getName() + "[]";
        }
        return type.getName();
    }

    private static boolean maybeIsRange(String cellValue) {
        Pattern p = Pattern.compile(".*(more|less|[;<>\\[\\(+\\.]).*|.*\\d+.*-.*");
        Matcher m = p.matcher(cellValue);
        return m.matches();
    }

    private static int getNumberOfConditions(DecisionTable decisionTable) {
        return decisionTable.getSignature().getNumberOfParameters();
    }

    public static IWritableGrid createVirtualGrid(String poiSheetName, int numberOfColumns) {
        XSSFWorkbook workbook = numberOfColumns > 256 ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = workbook.createSheet(poiSheetName);
        return DecisionTableHelper.createVirtualGrid(sheet, "/VIRTUAL_EXCEL_FILE_FOR_DISPATCHER_TABLES.xls");
    }

    public static boolean isSimpleDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleRules".equals(dtType);
    }

    public static boolean isSimpleLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleLookup".equals(dtType);
    }

    public static int countHConditions(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidHConditionHeader(value = value.toUpperCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int countVConditions(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    public static XlsSheetGridModel createVirtualGrid() {
        HSSFSheet sheet = new HSSFWorkbook().createSheet();
        return DecisionTableHelper.createVirtualGrid((Sheet)sheet, "/VIRTUAL_EXCEL_FILE.xls");
    }

    private static XlsSheetGridModel createVirtualGrid(Sheet sheet, String virtualExcelFile) {
        FileSourceCodeModule sourceCodeModule = new FileSourceCodeModule(virtualExcelFile, null);
        SimpleWorkbookLoader workbookLoader = new SimpleWorkbookLoader(sheet.getWorkbook());
        XlsWorkbookSourceCodeModule mockWorkbookSource = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)sourceCodeModule, workbookLoader);
        XlsSheetSourceCodeModule mockSheetSource = new XlsSheetSourceCodeModule(new SimpleSheetLoader(sheet), mockWorkbookSource);
        return new XlsSheetGridModel(mockSheetSource);
    }
}

