/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.List;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DTInfo;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.DecisionTableLookupConvertor;
import org.openl.rules.dt.element.Action;
import org.openl.rules.dt.element.Condition;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dtx.IBaseAction;
import org.openl.rules.dtx.IBaseCondition;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.utils.ParserUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public class DecisionTableLoader {
    protected static final String EMPTY_BODY = "Decision table must contain body section.";
    private int columnsNumber;
    private RuleRow ruleRow;
    DTInfo info;
    private List<IBaseCondition> conditions = new ArrayList<IBaseCondition>();
    private List<IBaseAction> actions = new ArrayList<IBaseAction>();

    private void addAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, false, DTScale.getStandardScale()));
    }

    private void addCondition(String name, int row, ILogicalTable table) {
        this.conditions.add(new Condition(name, row, table, this.getConditionScale(name)));
    }

    private DTScale.RowScale getConditionScale(String name) {
        if (DecisionTableHelper.isValidHConditionHeader(name.toUpperCase())) {
            return this.info.getScale().getHScale();
        }
        return this.info.getScale().getVScale();
    }

    private void addReturnAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, true, DTScale.getStandardScale()));
    }

    private void addRule(int row, ILogicalTable table, IBindingContext bindingContext) throws SyntaxNodeException {
        if (this.ruleRow != null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Only one rule row/column allowed", (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        this.ruleRow = new RuleRow(row, table);
    }

    public DecisionTable loadAndBind(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContext) throws Exception {
        this.loadTableStructure(tableSyntaxNode, decisionTable, (IBindingContext)bindingContext);
        IBaseCondition[] conditionsArray = this.conditions.toArray(new ICondition[this.conditions.size()]);
        IBaseAction[] actionsArray = this.actions.toArray(new IAction[this.actions.size()]);
        decisionTable.bindTable(conditionsArray, actionsArray, this.ruleRow, openl, (ComponentOpenClass)module, bindingContext, this.columnsNumber);
        return decisionTable;
    }

    private void loadTableStructure(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) throws SyntaxNodeException {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)EMPTY_BODY, (ISyntaxNode)tableSyntaxNode);
        }
        try {
            tableBody = this.preprocessSimpleDecisionTable(tableSyntaxNode, decisionTable, tableBody);
        }
        catch (OpenLCompilationException e) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot create a header for a Simple Rules or Lookup Table", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
        }
        ILogicalTable toParse = tableBody;
        int nHConditions = this.countHConditions(tableBody);
        int nVConditions = this.countVConditions(tableBody);
        if (nHConditions > 0) {
            try {
                DecisionTableLookupConvertor dtlc = new DecisionTableLookupConvertor();
                IGridTable convertedTable = dtlc.convertTable(tableBody);
                ILogicalTable offsetConvertedTable = LogicalTableHelper.logicalTable(convertedTable);
                toParse = (ILogicalTable)offsetConvertedTable.transpose();
                this.info = new DTInfo(nHConditions, nVConditions, dtlc.getScale());
            }
            catch (Exception e) {
                throw SyntaxNodeExceptionUtils.createError((String)"Cannot convert table", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
        } else if (DecisionTableHelper.looksLikeVertical(tableBody)) {
            toParse = (ILogicalTable)tableBody.transpose();
        }
        if (this.needToUnmergeFirstRow(toParse)) {
            toParse = this.unmergeFirstRow(toParse);
        }
        if (this.info == null) {
            this.info = new DTInfo(nHConditions, nVConditions);
        }
        decisionTable.setDtInfo(this.info);
        if (toParse.getWidth() < 4) {
            throw SyntaxNodeExceptionUtils.createError((String)"Invalid structure of decision table", (ISyntaxNode)tableSyntaxNode);
        }
        this.columnsNumber = toParse.getWidth() - 4;
        this.putTableForBusinessView(tableSyntaxNode);
        for (int i = 0; i < toParse.getHeight(); ++i) {
            this.loadRow(i, toParse, bindingContext);
        }
    }

    private ILogicalTable unmergeFirstRow(ILogicalTable toParse) {
        ILogicalTable unmerged = LogicalTableHelper.unmergeColumns(toParse, 4, toParse.getWidth());
        return unmerged;
    }

    private boolean needToUnmergeFirstRow(ILogicalTable toParse) {
        String header = this.getHeaderStr(0, toParse);
        return DecisionTableHelper.isConditionHeader(header) && !DecisionTableHelper.isValidMergedConditionHeader(header);
    }

    private void putTableForBusinessView(TableSyntaxNode tableSyntaxNode) {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode)) {
            tableSyntaxNode.getSubTables().put("business", tableBody);
        } else {
            ILogicalTable businessView = null;
            businessView = DecisionTableHelper.looksLikeVertical(tableBody) ? (ILogicalTable)tableBody.getRows(3) : (ILogicalTable)tableBody.getColumns(3);
            tableSyntaxNode.getSubTables().put("business", businessView);
        }
    }

    private ILogicalTable preprocessSimpleDecisionTable(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable tableBody) throws OpenLCompilationException {
        if (DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode)) {
            tableBody = DecisionTableHelper.preprocessSimpleDecisionTable(decisionTable, tableBody, 0);
        } else if (DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode)) {
            tableBody = DecisionTableHelper.preprocessSimpleDecisionTable(decisionTable, tableBody, tableBody.getSource().getCell(0, 0).getHeight());
        }
        return tableBody;
    }

    private int countHConditions(ILogicalTable tableBody) {
        return DecisionTableHelper.countHConditions(tableBody);
    }

    private int countVConditions(ILogicalTable tableBody) {
        return DecisionTableHelper.countVConditions(tableBody);
    }

    private String getHeaderStr(int row, ILogicalTable table) {
        String headerStr = ((ILogicalTable)table.getRow(row)).getSource().getCell(0, 0).getStringValue();
        if (headerStr == null) {
            return "";
        }
        return headerStr.toUpperCase();
    }

    private void loadRow(int row, ILogicalTable table, IBindingContext bindingContext) throws SyntaxNodeException {
        String header = this.getHeaderStr(row, table);
        if (DecisionTableHelper.isConditionHeader(header)) {
            this.addCondition(header, row, table);
        } else if (DecisionTableHelper.isValidActionHeader(header)) {
            this.addAction(header, row, table);
        } else if (DecisionTableHelper.isValidRuleHeader(header)) {
            this.addRule(row, table, bindingContext);
        } else if (DecisionTableHelper.isValidRetHeader(header)) {
            this.addReturnAction(header, row, table);
        } else if (!ParserUtils.isBlankOrCommented(header)) {
            throw SyntaxNodeExceptionUtils.createError((String)("Invalid Decision Table header:" + header), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
    }
}

