/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.rules.dt.TwoDimensionDecisionTableTranformer;
import org.openl.rules.table.IGridTable;

public class LookupHeadersTransformer
extends TwoDimensionDecisionTableTranformer {
    private int retStartIndex = 0;
    private int hcColumnStartAfterRet = 0;
    private int firstEmptyCell = 0;

    public LookupHeadersTransformer(IGridTable entireTable, IGridTable lookupValuesTable, int retTableWidth, int retColumnStartIndex, int firstEmptyCell) {
        super(entireTable, lookupValuesTable, retTableWidth);
        this.retStartIndex = retColumnStartIndex;
        this.firstEmptyCell = firstEmptyCell;
        this.hcColumnStartAfterRet = this.retStartIndex + this.getRetTableWidth();
    }

    @Override
    public int getColumn(int col, int row) {
        if (col < this.retStartIndex) {
            return super.getColumn(col, row);
        }
        if (this.retStartIndex <= col && col < this.retStartIndex + this.firstEmptyCell - this.hcColumnStartAfterRet) {
            return col + this.getRetTableWidth();
        }
        if (this.retStartIndex + this.firstEmptyCell - this.hcColumnStartAfterRet <= col && col < this.firstEmptyCell) {
            return col - (this.firstEmptyCell - this.hcColumnStartAfterRet);
        }
        return super.getColumn(col, row);
    }

    @Override
    public int getRow(int col, int row) {
        if (col < this.retStartIndex) {
            return super.getRow(col, row);
        }
        if (this.retStartIndex <= col && col < this.retStartIndex + this.firstEmptyCell - this.hcColumnStartAfterRet) {
            return row;
        }
        if (this.retStartIndex + this.firstEmptyCell - this.hcColumnStartAfterRet <= col && col < this.firstEmptyCell) {
            return row;
        }
        return super.getRow(col, row);
    }
}

